/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.PlatformUnauthenticatedClientConfiguration;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.client.adapter.ApiClientsResponseBuilder;
import com.mulesoft.mule.runtime.gw.client.adapter.ApiResponseBuilder;
import com.mulesoft.mule.runtime.gw.client.dto.ApiClientDto;
import com.mulesoft.mule.runtime.gw.client.dto.ApiDto;
import com.mulesoft.mule.runtime.gw.client.dto.CoreServicesClientDto;
import com.mulesoft.mule.runtime.gw.client.dto.PolicyTemplateDto;
import com.mulesoft.mule.runtime.gw.client.exception.EntityParsingException;
import com.mulesoft.mule.runtime.gw.client.exception.EntityUnparsingException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.httpclient.GatewayHttpClient;
import com.mulesoft.mule.runtime.gw.client.httpclient.GatewayHttpClientBuilder;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.BenchmarkInterceptor;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.HttpRequestResponseInterceptor;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.HttpResponseStatusInterceptor;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.Oauth2ClientCredentialsInterceptor;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.TraceInterceptor;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.UserAgentEnricherInterceptor;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.model.ClientRows;
import com.mulesoft.mule.runtime.gw.client.model.HttpEvent;
import com.mulesoft.mule.runtime.gw.client.model.HttpEventViews;
import com.mulesoft.mule.runtime.gw.client.model.Me;
import com.mulesoft.mule.runtime.gw.client.response.PlatformResponse;
import com.mulesoft.mule.runtime.gw.client.uri.HttpClientUriBuilder;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.mule.runtime.core.api.config.MuleManifest;
import org.slf4j.Logger;

public class ApiPlatformClient {
    public static final String GATEWAY_API_BASE_RESOURCE = "/apigateway/apimanager/v1";
    public static final String PROXIES_API_BASE_RESOURCE = "/proxies/xapi/v1";
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiPlatformClient.class);
    private static final String LOGIN_RESOURCE = "/apiplatform/login";
    private static final String APIS_RESOURCE = "/apigateway/apimanager/v1/apis/{apiId}";
    private static final String POLICY_TEMPLATE_RESOURCE = "/apigateway/apimanager/v1/templates";
    private static final String ACTIVE_ENDPOINT_RESOURCE = "/proxies/xapi/v1/organizations/{organizationId}/environments/{environmentId}/apis/{environmentApiId}/active";
    private static final String AUTH_RESOURCE = "/accounts/oauth2/token";
    private static final String ORGANIZATION_CLIENT_RESOURCE = "/accounts/api/organizations/{orgId}/clients/{clientId}";
    private static final String ME_RESOURCE = "/accounts/api/me";
    private static final String API_CONTRACTS_RESOURCE = "/apigateway/ccs/v2/organizations/{orgId}/environments/{environmentId}/apis/{environmentApiId}/contracts";
    private static final String ANALYTICS_EVENTS_RESOURCE = "/v2/analytics/events";
    private static final String METRICS_EVENTS_RESOURCE = "/apiruntime/v1/events";
    private final ObjectMapper objectMapper;
    private String platformBaseUri;
    private String analyticsBaseUri;
    private String metricsBaseUri;
    private String policyTemplateSource;
    private GatewayHttpClient client;
    private GatewayHttpClient unauthenticatedClient;
    private GatewayHttpClient metricsClient;
    private PlatformClientConfiguration configuration;
    private String orgId;
    private RestClientStatus status = RestClientStatus.NOT_INITIALISED;

    public ApiPlatformClient() {
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.objectMapper.setConfig(this.objectMapper.getSerializationConfig().withView(HttpEventViews.Public.class));
    }

    public void configure(GatewayConfiguration gatewayConfiguration) throws URISyntaxException {
        this.configuration = gatewayConfiguration.platformClient();
        this.platformBaseUri = this.configuration.getPlatformUri();
        this.analyticsBaseUri = this.configuration.getAnalyticsUri();
        this.metricsBaseUri = this.configuration.getMetricsBaseUri();
        this.policyTemplateSource = this.configuration.getPolicyTemplateSource();
        TraceInterceptor traceInterceptor = new TraceInterceptor(LOGGER);
        BenchmarkInterceptor benchmarkInterceptor = new BenchmarkInterceptor(LOGGER);
        URI oauthTokenUri = new URI(this.platformBaseUri + AUTH_RESOURCE);
        URI loginUri = new URI(this.platformBaseUri + LOGIN_RESOURCE);
        Oauth2ClientCredentialsInterceptor oauth2Interceptor = new Oauth2ClientCredentialsInterceptor(this.buildClient(traceInterceptor, benchmarkInterceptor), oauthTokenUri, loginUri, this.configuration.getClientId(), this.configuration.getClientSecret());
        this.client = this.buildClient(oauth2Interceptor, new UserAgentEnricherInterceptor(), traceInterceptor, benchmarkInterceptor, new HttpResponseStatusInterceptor());
        this.unauthenticatedClient = this.buildClient((PlatformClientConfiguration)new PlatformUnauthenticatedClientConfiguration(), this.configuration.enableSSLValidation(), new UserAgentEnricherInterceptor(), traceInterceptor, benchmarkInterceptor, new HttpResponseStatusInterceptor());
        this.metricsClient = this.buildClient((PlatformClientConfiguration)new PlatformUnauthenticatedClientConfiguration(), this.configuration.enableSSLValidation(), new UserAgentEnricherInterceptor(), traceInterceptor, benchmarkInterceptor, new HttpResponseStatusInterceptor());
    }

    private GatewayHttpClient buildClient(HttpRequestResponseInterceptor ... interceptors) {
        return this.buildClient(this.configuration, interceptors);
    }

    private GatewayHttpClient buildClient(PlatformClientConfiguration clientConfiguration, HttpRequestResponseInterceptor ... interceptors) {
        return this.buildClient(clientConfiguration, clientConfiguration.enableSSLValidation(), interceptors);
    }

    private GatewayHttpClient buildClient(PlatformClientConfiguration clientConfiguration, boolean sslValidationEnabled, HttpRequestResponseInterceptor ... interceptors) {
        return new GatewayHttpClientBuilder().withClientConfiguration(clientConfiguration).withRequestResponseInterceptors(interceptors).withSslValidationEnabled(sslValidationEnabled).build();
    }

    public void cleanConnections() {
        this.client.cleanConnections();
    }

    public PlatformResponse<ApiClientsResponse> getApiClients(String organizationId, String environmentId, Long apiId, String contractsEntityTag) {
        URI uri = new HttpClientUriBuilder().fromUri(this.platformBaseUri).appendPath(API_CONTRACTS_RESOURCE).build(organizationId, environmentId, apiId);
        HttpGet request = new HttpGet(uri);
        if (contractsEntityTag != null) {
            request.setHeader("If-None-Match", contractsEntityTag);
        }
        HttpResponse response = this.doExecute((HttpUriRequest)request);
        this.assertStatusCodes("Unable to retrieve contracts for " + apiId, response, 200, 304);
        int statusCode = this.statusCode(response);
        ApiClientsResponseBuilder apiClientsResponseBuilder = new ApiClientsResponseBuilder();
        if (statusCode == 200) {
            apiClientsResponseBuilder.withClients(this.parseClients(response));
            if (response.getFirstHeader("ETag") != null) {
                apiClientsResponseBuilder.withContractsEntityTag(response.getFirstHeader("ETag").getValue());
            }
        } else {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            apiClientsResponseBuilder.noUpdates();
        }
        return new PlatformResponse<ApiClientsResponse>(apiClientsResponseBuilder.build(), this.statusCode(response));
    }

    public PlatformResponse activateEndpoint(String organizationId, String environmentId, Long apiId) {
        URI uri = new HttpClientUriBuilder().fromUri(this.platformBaseUri).appendPath(ACTIVE_ENDPOINT_RESOURCE).build(organizationId, environmentId, apiId);
        HttpPost post = new HttpPost(uri);
        post.setEntity(this.emptyJsonEntity());
        HttpResponse response = this.doExecute((HttpUriRequest)post);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        this.assertStatusCodes("Unable to activate endpoint for " + apiId, response, 201);
        return new PlatformResponse<Object>(null, this.statusCode(response));
    }

    public PlatformResponse<ApiResponse> getApi(ApiKey apiKey, String apiEntityTag) {
        URI uri = new HttpClientUriBuilder().fromUri(this.platformBaseUri).appendPath(APIS_RESOURCE).queryParam("version", MuleManifest.getProductVersion()).build(apiKey.id());
        HttpGet request = new HttpGet(uri);
        if (apiEntityTag != null) {
            request.setHeader("If-None-Match", apiEntityTag);
        }
        HttpResponse response = this.doExecute((HttpUriRequest)request);
        this.assertStatusCodes("Unable to get API information from API Platform", response, 200, 304);
        int statusCode = this.statusCode(response);
        ApiResponseBuilder apiResponseBuilder = new ApiResponseBuilder();
        if (statusCode == 200) {
            apiResponseBuilder.withApi(this.parseEntity(response, ApiDto.class));
            if (response.getFirstHeader("ETag") != null) {
                apiResponseBuilder.withApiEntityTag(response.getFirstHeader("ETag").getValue());
            }
        } else {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            apiResponseBuilder.noUpdates();
        }
        return new PlatformResponse<ApiResponse>(apiResponseBuilder.build(), statusCode);
    }

    public int postHttpEvents(List<AnalyticsHttpEvent> events) throws IOException {
        ByteArrayEntity entity;
        LOGGER.trace("Sending events to analytics ingest: {}", events);
        URI uri = new HttpClientUriBuilder().fromUri(this.analyticsBaseUri).appendPath(ANALYTICS_EVENTS_RESOURCE).build(new Object[0]);
        ObjectWriter writer = this.objectMapper.writer();
        if (this.configuration.isOnPrem().booleanValue()) {
            writer = this.objectMapper.writerWithView(HttpEventViews.ExternalAnalytics.class);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            List eventsDto = events.stream().map(HttpEvent::from).collect(Collectors.toList());
            writer.writeValue((OutputStream)gzos, eventsDto);
            ContentType contentType = ContentType.create((String)"application/vnd.mulesoft.analytics.http-event+json", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("v", "2")});
            entity = new ByteArrayEntity(baos.toByteArray(), contentType);
        }
        catch (IOException e) {
            throw new EntityParsingException("Unable to parse HTTP Request content. " + ExceptionDescriptor.errorMessage((Throwable)e), e);
        }
        HttpPost postMethod = new HttpPost(uri);
        postMethod.setHeader("Content-Encoding", "gzip");
        postMethod.setEntity((HttpEntity)entity);
        HttpResponse response = this.client.execute((HttpUriRequest)postMethod);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        return this.statusCode(response);
    }

    public int postMetrics(String eventsBody) throws IOException {
        URI uri = new HttpClientUriBuilder().fromUri(this.metricsBaseUri).appendPath(METRICS_EVENTS_RESOURCE).build(new Object[0]);
        ContentType contentType = ContentType.create((String)"application/json");
        ByteArrayEntity entity = new ByteArrayEntity(eventsBody.getBytes(StandardCharsets.UTF_8), contentType);
        HttpPost postMethod = new HttpPost(uri);
        postMethod.setEntity((HttpEntity)entity);
        HttpResponse response = this.metricsClient.execute((HttpUriRequest)postMethod);
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        return this.statusCode(response);
    }

    public PlatformResponse<Me> connect() {
        URI uri = new HttpClientUriBuilder().fromUri(this.platformBaseUri).appendPath(ME_RESOURCE).build(new Object[0]);
        PlatformResponse<Me> response = this.execute((HttpUriRequest)new HttpGet(uri), Me.class);
        Me me = response.entity();
        this.orgId = me.getUser().getOrganization().getId();
        this.status = RestClientStatus.INITIALISED;
        return new PlatformResponse<Me>(me, response.statusCode());
    }

    public PolicyTemplateDto getPolicyTemplateMetadata(PolicyTemplateKey templateKey) {
        URI uri = new HttpClientUriBuilder().fromUri(this.platformBaseUri).appendPath(POLICY_TEMPLATE_RESOURCE).queryParam("muleVersion", MuleManifest.getProductVersion()).queryParam("groupId", templateKey.getGroupId()).queryParam("assetId", templateKey.getAssetId()).queryParam("version", templateKey.getVersion()).queryParam("source", this.policyTemplateSource).build(new Object[0]);
        return this.execute((HttpUriRequest)new HttpGet(uri), PolicyTemplateDto.class).entity();
    }

    public InputStream downloadTemplateAsset(String link) throws URISyntaxException, IOException {
        URI uri = new HttpClientUriBuilder().fromUri(link).build(new Object[0]);
        return this.unauthenticatedClient.execute((HttpUriRequest)new HttpGet(uri)).getEntity().getContent();
    }

    public String getOrgId() {
        return this.orgId;
    }

    public boolean isConnected() {
        return RestClientStatus.INITIALISED.equals((Object)this.status);
    }

    public void shutdown() {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    private void assertStatusCodes(String message, HttpResponse response, Integer ... validStatusCodes) {
        if (!Arrays.asList(validStatusCodes).contains(this.statusCode(response))) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            throw new HttpResponseException(message, this.statusCode(response));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ApiClientDto> parseClients(HttpResponse response) {
        try (Scanner scanner = new Scanner(this.content(response));){
            this.readCountRow(scanner);
            List<ApiClientDto> list = this.getApiClients(scanner);
            return list;
        }
        catch (IOException e) {
            throw new EntityUnparsingException("Unable to parse HTTP Response content. " + ExceptionDescriptor.errorMessage((Throwable)e), e, this.statusCode(response));
        }
    }

    private ClientRows readCountRow(Scanner scanner) throws IOException {
        String header = scanner.nextLine();
        return (ClientRows)this.objectMapper.readValue(header, ClientRows.class);
    }

    private List<ApiClientDto> getApiClients(Scanner scanner) throws IOException {
        ArrayList clients = Lists.newArrayList();
        while (scanner.hasNextLine()) {
            clients.add(this.objectMapper.readValue(scanner.nextLine(), ApiClientDto.class));
        }
        return clients;
    }

    public PlatformResponse<CoreServicesClientDto> getClient(String id) {
        URI uri = new HttpClientUriBuilder().fromUri(this.platformBaseUri).appendPath(ORGANIZATION_CLIENT_RESOURCE).build(this.getOrgId(), id);
        return this.execute((HttpUriRequest)new HttpGet(uri), CoreServicesClientDto.class);
    }

    private int statusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private <T> T parseEntity(HttpResponse response, Class<T> valueType) {
        try {
            return (T)this.objectMapper.readValue(this.content(response), valueType);
        }
        catch (IOException e) {
            throw new EntityUnparsingException("Unable to parse HTTP Response content. " + ExceptionDescriptor.errorMessage((Throwable)e), e, this.statusCode(response));
        }
    }

    private InputStream content(HttpResponse response) {
        try {
            return response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new HttpConnectionException("Unable to read HTTP Response content. " + ExceptionDescriptor.errorMessage((Throwable)e), e);
        }
    }

    private HttpEntity emptyJsonEntity() {
        return new StringEntity("", ContentType.APPLICATION_JSON);
    }

    private <T> PlatformResponse<T> execute(HttpUriRequest request, Class<T> valueType) {
        HttpResponse response = this.doExecute(request);
        return new PlatformResponse<T>(this.parseEntity(response, valueType), this.statusCode(response));
    }

    private HttpResponse doExecute(HttpUriRequest request) {
        try {
            return this.client.execute(request);
        }
        catch (IOException e) {
            throw new HttpConnectionException("Unable to execute HTTP Request. " + ExceptionDescriptor.errorMessage((Throwable)e), e);
        }
    }

    public static enum RestClientStatus {
        NOT_INITIALISED,
        INITIALISED;

    }
}

