/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import com.google.common.collect.ImmutableList;
import com.mulesoft.mule.runtime.gw.client.exception.EntityParsingException;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.Oauth2Interceptor;
import com.mulesoft.mule.runtime.gw.client.model.Authentication;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class Oauth2ClientCredentialsInterceptor
extends Oauth2Interceptor {
    private URI tokenUrl;
    private String clientId;
    private String clientSecret;

    public Oauth2ClientCredentialsInterceptor(HttpClient client, URI tokenUrl, URI loginUrl, String clientId, String clientSecret) {
        super(client, loginUrl);
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public String authenticate() {
        try {
            ImmutableList form = ImmutableList.of((Object)new BasicNameValuePair("grant_type", "client_credentials"), (Object)new BasicNameValuePair("client_id", this.clientId), (Object)new BasicNameValuePair("client_secret", this.clientSecret));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity((List)form, "UTF-8");
            HttpResponse response = this.executePost(this.tokenUrl, (HttpEntity)entity);
            return this.processResponse(response, Authentication.class).getAccessToken();
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityParsingException("Error building HTTP Request entity", e);
        }
    }
}

