/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import com.mulesoft.mule.runtime.gw.client.auth.AccessTokens;
import com.mulesoft.mule.runtime.gw.client.auth.ApiPlatformAuthenticator;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.GatewayAuthScheme;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.HttpRequestResponseInterceptor;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

public class AuthenticationInterceptor
implements HttpRequestResponseInterceptor {
    private static final String ACCESS_TOKEN_KEY = "com.mulesoft.module.client.httpclient.interceptors.accessToken";
    private final ApiPlatformAuthenticator authenticator;

    public AuthenticationInterceptor(ApiPlatformAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void process(HttpRequest request, HttpContext context) {
        String authorizationHeaderToken;
        AccessTokens currentTokens = this.authenticator.authenticate();
        if (request.containsHeader("Authorization")) {
            request.removeHeaders("Authorization");
        }
        HttpClientContext clientContext = (HttpClientContext)context;
        String string = authorizationHeaderToken = request.getRequestLine().getUri().contains("/apigateway/apimanager/v1") || request.getRequestLine().getUri().contains("/proxies/xapi/v1") ? currentTokens.getApiManagerToken() : currentTokens.getCoreServicesToken();
        if (authorizationHeaderToken != null) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(authorizationHeaderToken, null);
            clientContext.getTargetAuthState().update((AuthScheme)new GatewayAuthScheme(), (Credentials)credentials);
        }
        context.setAttribute(ACCESS_TOKEN_KEY, (Object)currentTokens.getCoreServicesToken());
    }

    public void process(HttpResponse response, HttpContext context) {
        String accessTokenInUse = (String)context.getAttribute(ACCESS_TOKEN_KEY);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 403 || statusCode == 401) {
            this.authenticator.unauthorizedUsing(accessTokenInUse);
        }
    }
}

