/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.session;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.adapter.ApiClientsResponseBuilder;
import com.mulesoft.mule.runtime.gw.client.adapter.ApiResponseBuilder;
import com.mulesoft.mule.runtime.gw.client.dto.ApiDto;
import com.mulesoft.mule.runtime.gw.client.exception.EntityUnparsingException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.model.Api;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang.NotImplementedException;

public class FileSystemPlatformSession
implements ApiPlatformSession {
    private final File apiDirectory;
    private final ObjectMapper objectMapper;

    public FileSystemPlatformSession(File apiDirectory) {
        this.apiDirectory = apiDirectory;
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    @Override
    public SessionMetadata metadata() {
        throw new NotImplementedException();
    }

    @Override
    public ApiPlatformSession activateEndpoint(String organizationId, String environmentId, Long apiId) {
        return this;
    }

    @Override
    public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId) {
        return this.getApiClients(organizationId, environmentId, apiId, null);
    }

    @Override
    public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId, String contractsEntityTag) {
        return new ApiClientsResponseBuilder().withClients(Collections.emptyList()).build();
    }

    @Override
    public ApiResponse getApi(Api api) {
        return this.getApi(api.getKey());
    }

    @Override
    public ApiResponse getApi(ApiKey apiKey) {
        return this.getApi(apiKey, null);
    }

    @Override
    public ApiResponse getApi(ApiKey apiKey, String apiEntityTag) {
        return new ApiResponseBuilder().withApi(this.parseEntity(this.getApiFile(apiKey), ApiDto.class)).build();
    }

    private File getApiFile(ApiKey apiKey) {
        File apiFile = new File(this.getApiDirectory(), this.getApiFileName(apiKey));
        if (!apiFile.exists() || !apiFile.isFile()) {
            throw new NotFoundException(String.format("Could not find information for api %s", apiKey.id()));
        }
        return apiFile;
    }

    private File getApiDirectory() {
        if (!this.apiDirectory.exists() || !this.apiDirectory.isDirectory()) {
            throw new RuntimeException("Could not find api information folder, check that it is correctly configured.");
        }
        return this.apiDirectory;
    }

    private String getApiFileName(ApiKey apiKey) {
        return String.format("%s.json", apiKey.id());
    }

    private <T> T parseEntity(File response, Class<T> valueType) {
        try {
            return (T)this.objectMapper.readValue(response, valueType);
        }
        catch (IOException e) {
            throw new EntityUnparsingException("Unable to parse HTTP Response content. " + ExceptionDescriptor.errorMessage((Throwable)e), e);
        }
    }
}

