/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import com.mulesoft.mule.runtime.gw.client.dto.ApiDto;
import com.mulesoft.mule.runtime.gw.client.dto.IdentityManagementDto;
import com.mulesoft.mule.runtime.gw.client.dto.PolicyDefinitionDto;
import com.mulesoft.mule.runtime.gw.client.dto.PolicyTemplateKeyDto;
import com.mulesoft.mule.runtime.gw.client.exception.EntityUnparsingException;

public class ApiDtoValidator {
    public void validate(ApiDto dto) {
        dto.getPolicies().forEach(this::validatePolicy);
        this.validateIdentityManagement(dto.getIdentityManagement());
    }

    private void validateIdentityManagement(IdentityManagementDto identityManagement) {
        if (this.isNull(identityManagement)) {
            return;
        }
        this.expect(this.notEmpty(identityManagement.getTokenUrl()), "Invalid identity management token URL.");
    }

    private void validatePolicy(PolicyDefinitionDto dto) {
        this.expect(this.notEmpty(dto.getId()), "Invalid policy id.");
        this.expect(this.validTemplateKey(dto.getPolicyTemplateKey()), "Invalid template key.");
        this.expect(this.notEmpty(dto.getVersion()), "Invalid policy version.");
    }

    private void expect(boolean condition, String message) {
        if (!condition) {
            throw new EntityUnparsingException(message, 200);
        }
    }

    private boolean isNull(Object value) {
        return value == null;
    }

    private boolean notEmpty(String value) {
        return !this.isNull(value) && !value.isEmpty();
    }

    private boolean validTemplateKey(PolicyTemplateKeyDto dto) {
        return !this.isNull(dto) && this.notEmpty(dto.getGroupId()) && this.notEmpty(dto.getAssetId()) && this.notEmpty(dto.getVersion());
    }
}

