/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.provider;

import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.exception.GatewayConfigurationException;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.exception.NormalizedExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.exception.UnauthorizedException;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ApiPlatformClientProvider {
    private static final String CONNECTION_ERROR_DESCRIPTION = "connect with API Manager";
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiPlatformClientProvider.class);
    private final NormalizedExceptionMessageLogger normalizedLogger = new RecoverableExceptionMessageLogger(LOGGER);
    private ApiPlatformClient client;
    private final RunnableRetrier<String> retrier;
    private List<ApiPlatformClientConnectionListener> connectionListeners = new CopyOnWriteArrayList<ApiPlatformClientConnectionListener>();

    public ApiPlatformClientProvider(RunnableRetrier<String> reconnectionRetrier) {
        this.client = new ApiPlatformClient();
        this.retrier = reconnectionRetrier;
    }

    public boolean configureClient(GatewayConfiguration configuration) {
        try {
            if (this.validConfiguration(configuration)) {
                this.client.configure(configuration);
                return true;
            }
        }
        catch (GatewayConfigurationException e) {
            LOGGER.error("Unable to start API Platform Client. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        catch (URISyntaxException e) {
            LOGGER.error("Invalid URL configured. API Platform client is DISABLED. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        catch (Exception e) {
            LOGGER.error("An invalid Gateway configuration was detected. API Platform client is DISABLED. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        return false;
    }

    public void connectClient() {
        try {
            this.doConnect();
        }
        catch (Throwable t) {
            this.retrier.scheduleRetry((Object)"clientConnect", this::doConnect);
        }
    }

    private void doConnect() {
        try {
            this.client.connect();
            LOGGER.info("Client ID and Client Secret successfully validated against API Manager.");
            this.notifyListeners();
        }
        catch (UnauthorizedException e) {
            LOGGER.error("Client ID and Client Secret could not be validated against API Manager.");
            this.normalizedLogger.error(CONNECTION_ERROR_DESCRIPTION, e);
            throw e;
        }
        catch (Throwable t) {
            this.normalizedLogger.error(CONNECTION_ERROR_DESCRIPTION, t);
            throw t;
        }
    }

    public ApiPlatformClient getClient() {
        return this.client;
    }

    public void shutdown() {
        this.client.shutdown();
        this.retrier.dispose();
    }

    public void addConnectionListener(ApiPlatformClientConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    private void notifyListeners() {
        this.connectionListeners.forEach(listener -> {
            try {
                listener.onClientConnected();
            }
            catch (Exception e) {
                LOGGER.warn("Error on Platform Client connected listener. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
            }
        });
    }

    private boolean validConfiguration(GatewayConfiguration configuration) {
        if (!this.platformUriIsSet(configuration)) {
            if (configuration.platformClient().isOnPrem().booleanValue()) {
                LOGGER.warn("On Prem mode is enabled but anypoint.platform.base_uri is not set. API Platform client is DISABLED.");
            } else {
                LOGGER.warn("anypoint.platform.base_uri is not set. API Platform client is DISABLED.");
            }
            return false;
        }
        if (configuration.platformClient().isOfflineModeEnabled()) {
            LOGGER.warn("Client ID or Client Secret were not provided. API Platform client is DISABLED.");
            return false;
        }
        return true;
    }

    private boolean platformUriIsSet(GatewayConfiguration configuration) {
        return !StringUtils.isBlank((CharSequence)configuration.platformClient().getPlatformUri());
    }
}

