/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;

public interface ApiContractsPrefetch {

  /**
   * Indicates that contracts for the key will be eventually requested and should be preemptively available
   *
   * @param key to prefetch contracts for.
   * @return (Subclass) this.
   */
  default ApiContractsPrefetch contractsRequired(ApiKey key) {
    return this;
  }

  /**
   * Indicates that contracts for the key are no longer required.
   *
   * @param key to the api that no longer requires contracts.
   * @return (Subclass) this.
   */
  default ApiContractsPrefetch noContractsRequired(ApiKey key) {
    return this;
  }


}
