/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.gateway.service;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.exception.ForbiddenClientException;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class MockApiContract implements ApiContracts {


  private final ApiKey key;
  private List<Contract> contracts;

  public MockApiContract(ApiKey key, List<Contract> contracts) {
    this.key = key;
    this.contracts = contracts;
  }

  @Override
  public ApiContracts updateContracts(List<Contract> contracts) {
    this.contracts = contracts;
    return this;
  }

  @Override
  public ApiContracts updateContracts(Contract... contracts) {
    return updateContracts(Arrays.asList(contracts));
  }

  @Override
  public Sla sla(Client client) throws ForbiddenClientException {
    return contracts.stream()
        .filter(contract -> contract.client().equals(client))
        .findFirst()
        .map(Contract::sla)
        .orElseThrow(ForbiddenClientException::new);
  }

  @Override
  public Sla sla(String clientId) throws ForbiddenClientException {
    return contracts.stream()
        .filter(contract -> contract.client().id().equals(clientId))
        .findFirst()
        .map(Contract::sla)
        .orElseThrow(ForbiddenClientException::new);
  }

  @Override
  public Client validate(String clientId, String clientSecret) throws ForbiddenClientException {
    return contracts.stream()
        .filter(contract -> contract.client().id().equals(clientId) && contract.client().secret().equals(clientSecret))
        .findFirst()
        .map(Contract::client)
        .orElseThrow(ForbiddenClientException::new);
  }

  @Override
  public Client validate(String clientId) throws ForbiddenClientException {
    return contracts.stream()
        .filter(contract -> contract.client().id().equals(clientId))
        .findFirst()
        .map(Contract::client)
        .orElseThrow(ForbiddenClientException::new);
  }
}
