/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.gateway.service;

import static java.util.Optional.ofNullable;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.ApiContractsSupplier;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.service.ApiContractsPrefetch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MockApiContractsSupplier implements ApiContractsSupplier, ApiContractsPrefetch {

  private final Map<ApiKey, ApiContracts> apis;
  private final Set<ApiKey> prefetch;

  public MockApiContractsSupplier() {
    this.apis = new HashMap<>();
    this.prefetch = new HashSet<>();
  }

  @Override
  public Optional<ApiContracts> getContracts(ApiKey key) {
    return ofNullable(apis.get(key));
  }

  @Override
  public ApiContractsPrefetch contractsRequired(ApiKey key) {
    this.prefetch.add(key);
    return this;
  }

  @Override
  public ApiContractsPrefetch noContractsRequired(ApiKey key) {
    this.prefetch.remove(key);
    return this;
  }

  public MockApiContractsSupplier set(ApiKey key, List<Contract> contracts) {
    apis.put(key, new MockApiContract(key, contracts));
    return this;
  }

  public Set<ApiKey> prefetchedKeys() {
    return prefetch;
  }
}
