/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.gateway.service;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.DebugLine;
import com.mulesoft.anypoint.tests.logger.ErrorLine;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.mule.gateway.service.ContractServiceImplementation;
import com.mulesoft.mule.gateway.service.MockApiContractsSupplier;
import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.ApiContractsSupplier;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.contract.tier.SingleTier;
import com.mulesoft.mule.runtime.gw.api.contract.tier.Tier;
import com.mulesoft.mule.runtime.gw.api.exception.ForbiddenClientException;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.service.ApiContractsPrefetch;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.api.service.exception.UnknownAPIException;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

public class ContractServiceTestCase {
    private static final String TRACKER = "My trekking boots";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    private ContractService service;
    private MockApiContractsSupplier contractSupplier;
    private MockLogger mockLogger;

    @Before
    public void setUp() throws NoSuchFieldException, IllegalAccessException {
        this.mockLogger = new MockLogger();
        this.contractSupplier = new MockApiContractsSupplier();
        this.service = new ContractServiceImplementation().contractSupplier((ApiContractsSupplier)this.contractSupplier).contractPrefetch((ApiContractsPrefetch)this.contractSupplier);
        VariableOverride.overrideVariable((String)"LOGGER").in((Object)this.service).with((Object)this.mockLogger);
    }

    @Test
    public void apiNotTrackedByServiceRaisesException() throws UnknownAPIException {
        this.expectedUnknownAPI();
        this.service.contracts(this.key());
    }

    @Test
    public void createAPIWithNoContracts() throws UnknownAPIException {
        this.contractSupplier.set(this.key(), this.noContracts());
        ApiContracts obtainedAPIContracts = this.service.contracts(this.key());
        Assert.assertEquals((String)"Api should not have any clients", (Object)this.contractSupplier.getContracts(this.key()).get(), (Object)obtainedAPIContracts);
    }

    @Test
    public void createAPIWithMultipleContracts() throws ForbiddenClientException, UnknownAPIException {
        this.contractSupplier.set(this.key(), this.allContracts());
        ApiContracts obtainedAPIContracts = this.service.contracts(this.key());
        obtainedAPIContracts.validate(this.client().id(), this.client().secret());
        obtainedAPIContracts.validate(this.aThirdClient().id(), this.aThirdClient().secret());
        obtainedAPIContracts.validate(this.anotherClient().id(), this.anotherClient().secret());
        this.assertClientNotValid(obtainedAPIContracts, this.unknownClient());
    }

    @Test
    public void requestInexistentApi() throws UnknownAPIException {
        this.thrown.expect(UnknownAPIException.class);
        this.service.contracts(this.key());
    }

    @Test
    public void notifyServiceAPIsThatContainContracts() {
        this.service.track(this.key(), TRACKER);
        MatcherAssert.assertThat((Object)this.service.trackedApis(), (Matcher)Matchers.hasItem((Object)this.key()));
        MatcherAssert.assertThat((Object)this.service.trackedApis(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.anotherKey())));
        MatcherAssert.assertThat((Object)this.mockLogger.lines(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.mockLogger.lines().get(0), (Matcher)Matchers.is((Object)this.trackerAddedDebugLine(this.key())));
    }

    @Test
    public void contractTrackingFiresPrefetch() {
        this.service.track(this.key(), TRACKER);
        MatcherAssert.assertThat(this.contractSupplier.prefetchedKeys(), (Matcher)Matchers.hasItem((Object)this.key()));
    }

    @Test
    public void trackUntrack() {
        this.service.track(this.key(), TRACKER);
        this.service.untrack(this.key(), TRACKER);
        MatcherAssert.assertThat(this.contractSupplier.prefetchedKeys(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.key())));
    }

    @Test
    public void multipleTrackSingleUntrack() {
        this.service.track(this.key(), TRACKER);
        this.service.track(this.key(), TRACKER);
        this.service.untrack(this.key(), TRACKER);
        MatcherAssert.assertThat(this.contractSupplier.prefetchedKeys(), (Matcher)Matchers.hasItem((Object)this.key()));
    }

    @Test
    public void multipleTrackMultipleUntrack() {
        this.service.track(this.key(), TRACKER);
        this.service.track(this.key(), TRACKER);
        this.service.untrack(this.key(), TRACKER);
        this.service.untrack(this.key(), TRACKER);
        MatcherAssert.assertThat(this.contractSupplier.prefetchedKeys(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.key())));
    }

    @Test
    public void serviceNotificationIsIdempotent() {
        this.service.track(this.key(), TRACKER).track(this.key(), TRACKER).track(this.key(), TRACKER);
        MatcherAssert.assertThat((Object)this.service.trackedApis(), (Matcher)Matchers.hasItem((Object)this.key()));
        MatcherAssert.assertThat((Object)this.service.trackedApis(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.anotherKey())));
        MatcherAssert.assertThat((Object)this.mockLogger.lines(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(this.mockLogger.lines().get(0), (Matcher)Matchers.is((Object)this.trackerAddedDebugLine(this.key())));
        MatcherAssert.assertThat(this.mockLogger.lines().get(1), (Matcher)Matchers.is((Object)this.trackerAddedDebugLine(this.key())));
        MatcherAssert.assertThat(this.mockLogger.lines().get(2), (Matcher)Matchers.is((Object)this.trackerAddedDebugLine(this.key())));
    }

    @Test
    public void shouldNotFetchContractsIfAPIHasBeenRemoved() throws UnknownAPIException {
        this.service.track(this.key(), TRACKER).track(this.anotherKey(), TRACKER).untrack(this.key(), TRACKER);
        MatcherAssert.assertThat((Object)this.service.trackedApis(), (Matcher)Matchers.hasItem((Object)this.anotherKey()));
        MatcherAssert.assertThat((Object)this.service.trackedApis(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.key())));
        MatcherAssert.assertThat((Object)this.mockLogger.lines(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(this.mockLogger.lines().get(0), (Matcher)Matchers.is((Object)this.trackerAddedDebugLine(this.key())));
        MatcherAssert.assertThat(this.mockLogger.lines().get(1), (Matcher)Matchers.is((Object)this.trackerAddedDebugLine(this.anotherKey())));
        MatcherAssert.assertThat(this.mockLogger.lines().get(2), (Matcher)Matchers.is((Object)this.trackerRemovedDebugLine()));
    }

    @Test
    public void eachTrackMustBeUnTracked() {
        this.service.track(this.key(), TRACKER).track(this.key(), TRACKER).untrack(this.key(), TRACKER).untrack(this.key(), "another name just for description");
        MatcherAssert.assertThat((Object)this.service.trackedApis(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.key())));
    }

    @Test
    public void reTracking() {
        this.service.track(this.key(), TRACKER).untrack(this.key(), TRACKER).track(this.key(), TRACKER).untrack(this.key(), "another name just for description");
        MatcherAssert.assertThat((Object)this.service.trackedApis(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.key())));
    }

    @Test
    public void noApiSupplierRaisesException() throws UnknownAPIException {
        this.thrown.expect(UnknownAPIException.class);
        this.thrown.expectMessage("Cannot lookup " + this.key() + " as there is no ApiContractsSupplier");
        new ContractServiceImplementation().contracts(this.key());
    }

    @Test
    public void untrackNotTrackedApis() {
        this.service.untrack(this.key(), TRACKER);
        MatcherAssert.assertThat((Object)this.service.trackedApis(), (Matcher)Matchers.is(Arrays.asList(new Object[0])));
        MatcherAssert.assertThat((Object)this.mockLogger.lines(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.mockLogger.lines().get(0), (Matcher)Matchers.is((Object)new ErrorLine("Trying to untrack Api: {} that hasn't been tracked.", new Object[]{this.key()})));
    }

    private Client unknownClient() {
        return Client.builder().withId("inexistentClient").withSecret("inexistentSecret").withName("inexistantName").build();
    }

    private List<Contract> allContracts() {
        return Arrays.asList(this.contract(), this.anotherContract(), this.aThirdContract());
    }

    private List<Contract> noContracts() {
        return new ArrayList<Contract>();
    }

    private ApiKey key() {
        return PolicyTestValuesConstants.API_KEY;
    }

    private ApiKey anotherKey() {
        return PolicyTestValuesConstants.API_KEY_2;
    }

    private void assertClientNotValid(ApiContracts apiContracts, Client client) {
        try {
            apiContracts.validate(client.id(), client.secret());
            Assert.fail((String)(client + " should not be validated!"));
        }
        catch (ForbiddenClientException e) {
            Assert.assertEquals((Object)"Invalid client id or secret", (Object)e.getMessage());
        }
    }

    private void expectedUnknownAPI() {
        this.thrown.expect(UnknownAPIException.class);
        this.thrown.expectMessage("ContractService is not tracking " + this.key() + ".");
    }

    private Client client() {
        return Client.builder().withId("id").withSecret("secret").withName("some name").build();
    }

    private Client anotherClient() {
        return Client.builder().withId("another-id").withSecret("secret").withName("some name").build();
    }

    private Client aThirdClient() {
        return Client.builder().withId("third-id").withSecret("someSecretHeHasToKeep =o").withName("some name").build();
    }

    private Contract contract() {
        return Contract.builder().withClient(this.client()).withSla(new Sla(Integer.valueOf(1), new Tier[0])).build();
    }

    private Contract anotherContract() {
        return Contract.builder().withClient(this.anotherClient()).withSla(new Sla(Integer.valueOf(2), new Tier[]{new SingleTier(Integer.valueOf(3), Long.valueOf(2L))})).build();
    }

    private Contract aThirdContract() {
        return Contract.builder().withClient(this.aThirdClient()).withSla(new Sla(Integer.valueOf(3), new Tier[0])).build();
    }

    private DebugLine trackerAddedDebugLine(ApiKey key) {
        return new DebugLine("API {} expects contracts as it is used by {}.", new Object[]{key.id(), TRACKER});
    }

    private DebugLine trackerRemovedDebugLine() {
        return new DebugLine("Tracker {} does not need contracts for API {} anymore.", new Object[]{TRACKER, this.key().id()});
    }
}

