/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.gateway.service;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.ApiContractsSupplier;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.service.ApiContractsPrefetch;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.api.service.exception.UnknownAPIException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractServiceImplementation
implements ContractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContractServiceImplementation.class);
    private ApiContractsSupplier apiContractsSupplier;
    private ApiContractsPrefetch apiContractsPrefetch;
    private final List<ApiKey> apisTrackedForContracts = new ArrayList<ApiKey>();

    public ContractService contractSupplier(ApiContractsSupplier supplier) {
        this.apiContractsSupplier = supplier;
        return this;
    }

    public ContractService contractPrefetch(ApiContractsPrefetch prefetch) {
        this.apiContractsPrefetch = prefetch;
        return this;
    }

    public ApiContracts contracts(ApiKey apiKey) throws UnknownAPIException {
        this.checkSupplierNonNull(apiKey);
        return (ApiContracts)this.apiContractsSupplier.getContracts(apiKey).orElseThrow(() -> new UnknownAPIException("ContractService is not tracking " + String.valueOf(apiKey) + "."));
    }

    public ContractService track(ApiKey key, String trackerDescription) {
        this.apisTrackedForContracts.add(key);
        LOGGER.debug("API {} expects contracts as it is used by {}.", (Object)key.id(), (Object)trackerDescription);
        Optional.ofNullable(this.apiContractsPrefetch).ifPresent(supplier -> this.apiContractsPrefetch.contractsRequired(key));
        return this;
    }

    public ContractService untrack(ApiKey key, String trackerDescription) {
        if (!this.apisTrackedForContracts.contains(key)) {
            LOGGER.error("Trying to untrack Api: {} that hasn't been tracked.", (Object)key);
        } else {
            this.apisTrackedForContracts.remove(key);
            if (!this.apisTrackedForContracts.contains(key)) {
                Optional.ofNullable(this.apiContractsPrefetch).ifPresent(supplier -> this.apiContractsPrefetch.noContractsRequired(key));
                LOGGER.debug("Tracker {} does not need contracts for API {} anymore.", (Object)trackerDescription, (Object)key.id());
            } else {
                LOGGER.debug("After untrack, tracker {} has still at least one instance that need contracts for API {}.", (Object)trackerDescription, (Object)key.id());
            }
        }
        return this;
    }

    public List<ApiKey> trackedApis() {
        return this.apisTrackedForContracts;
    }

    public String getName() {
        return "ContractService";
    }

    private void checkSupplierNonNull(ApiKey apiKey) throws UnknownAPIException {
        if (this.apiContractsSupplier == null) {
            throw new UnknownAPIException("Cannot lookup " + String.valueOf(apiKey) + " as there is no ApiContractsSupplier");
        }
    }
}

