/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.gateway.service;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.exception.ForbiddenClientException;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import java.util.Arrays;
import java.util.List;

public class MockApiContract
implements ApiContracts {
    private final ApiKey key;
    private List<Contract> contracts;

    public MockApiContract(ApiKey key, List<Contract> contracts) {
        this.key = key;
        this.contracts = contracts;
    }

    public ApiContracts updateContracts(List<Contract> contracts) {
        this.contracts = contracts;
        return this;
    }

    public ApiContracts updateContracts(Contract ... contracts) {
        return this.updateContracts(Arrays.asList(contracts));
    }

    public Sla sla(Client client) throws ForbiddenClientException {
        return this.contracts.stream().filter(contract -> contract.client().equals((Object)client)).findFirst().map(Contract::sla).orElseThrow(ForbiddenClientException::new);
    }

    public Sla sla(String clientId) throws ForbiddenClientException {
        return this.contracts.stream().filter(contract -> contract.client().id().equals(clientId)).findFirst().map(Contract::sla).orElseThrow(ForbiddenClientException::new);
    }

    public Client validate(String clientId, String clientSecret) throws ForbiddenClientException {
        return this.contracts.stream().filter(contract -> contract.client().id().equals(clientId) && contract.client().secret().equals(clientSecret)).findFirst().map(Contract::client).orElseThrow(ForbiddenClientException::new);
    }

    public Client validate(String clientId) throws ForbiddenClientException {
        return this.contracts.stream().filter(contract -> contract.client().id().equals(clientId)).findFirst().map(Contract::client).orElseThrow(ForbiddenClientException::new);
    }
}

