/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.gateway.events.collector.service;

import com.mulesoft.mule.gateway.events.collector.service.DefaultEventsCollectorService;
import com.mulesoft.mule.gateway.events.collector.service.EventsCollectorProvider;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import java.util.HashMap;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class EventCollectorServiceTestCase {
    @Test
    public void checkName() {
        MatcherAssert.assertThat((Object)new DefaultEventsCollectorService().getName(), (Matcher)CoreMatchers.is((Object)"EventsCollectorService"));
    }

    @Test
    public void inexistentViolation() {
        MatcherAssert.assertThat((Object)new DefaultEventsCollectorService().getPolicyViolation("inexistentId"), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void addViolation() {
        DefaultEventsCollectorService service = new DefaultEventsCollectorService();
        PolicyViolation policyViolation = (PolicyViolation)Mockito.mock(PolicyViolation.class);
        service.addPolicyViolation("id", policyViolation);
        MatcherAssert.assertThat((Object)service.getPolicyViolation("id"), (Matcher)CoreMatchers.is(Optional.of(policyViolation)));
    }

    @Test
    public void onlyLastViolationIsSaved() {
        DefaultEventsCollectorService service = new DefaultEventsCollectorService();
        PolicyViolation firstViolation = (PolicyViolation)Mockito.mock(PolicyViolation.class);
        PolicyViolation lastViolation = (PolicyViolation)Mockito.mock(PolicyViolation.class);
        service.addPolicyViolation("id", firstViolation);
        service.addPolicyViolation("id", lastViolation);
        MatcherAssert.assertThat((Object)service.getPolicyViolation("id"), (Matcher)CoreMatchers.is(Optional.of(lastViolation)));
    }

    @Test
    public void addAnotherEventViolation() {
        DefaultEventsCollectorService service = new DefaultEventsCollectorService();
        PolicyViolation violation = (PolicyViolation)Mockito.mock(PolicyViolation.class);
        PolicyViolation anotherViolation = (PolicyViolation)Mockito.mock(PolicyViolation.class);
        service.addPolicyViolation("id1", violation);
        service.addPolicyViolation("id2", anotherViolation);
        MatcherAssert.assertThat((Object)service.getPolicyViolation("id1"), (Matcher)CoreMatchers.is(Optional.of(violation)));
        MatcherAssert.assertThat((Object)service.getPolicyViolation("id2"), (Matcher)CoreMatchers.is(Optional.of(anotherViolation)));
    }

    @Test
    public void removeViolation() {
        DefaultEventsCollectorService service = new DefaultEventsCollectorService();
        PolicyViolation violation = (PolicyViolation)Mockito.mock(PolicyViolation.class);
        service.addPolicyViolation("id1", violation);
        service.removePolicyViolation("id1");
        MatcherAssert.assertThat((Object)service.getPolicyViolation("id1"), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void removeInexistentViolation() {
        DefaultEventsCollectorService service = new DefaultEventsCollectorService();
        service.removePolicyViolation("id1");
        MatcherAssert.assertThat((Object)service.getPolicyViolation("id1"), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void addViolationExtraData() {
        DefaultEventsCollectorService service = new DefaultEventsCollectorService();
        HashMap<String, String> extraData = new HashMap<String, String>();
        extraData.put("prop1", "value1");
        service.addExtraViolationData("id1", extraData);
        MatcherAssert.assertThat((Object)service.getExtraViolationData("id1"), (Matcher)CoreMatchers.is(Optional.of(extraData)));
    }

    @Test
    public void removeViolationExtraData() {
        DefaultEventsCollectorService service = new DefaultEventsCollectorService();
        HashMap extraData = new HashMap();
        service.addExtraViolationData("id1", extraData);
        service.removeExtraViolationData("id1");
        service.removeExtraViolationData("id2");
        MatcherAssert.assertThat((Object)service.removeExtraViolationData("id1"), (Matcher)CoreMatchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)service.removeExtraViolationData("id2"), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void addInexistentViolationExtraData() {
        DefaultEventsCollectorService service = new DefaultEventsCollectorService();
        MatcherAssert.assertThat((Object)service.getExtraViolationData("id1"), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void untesteableEventProvider() {
        new EventsCollectorProvider().getServiceDefinition();
    }
}

