/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.analytics;

import static com.mulesoft.anypoint.tests.CountProber.descriptiveCountProber;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.GROUP_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tests.infrastructure.model.FakeApiModel.fakeModel;
import static com.mulesoft.anypoint.tita.TestDependencies.testAuthenticationDependency;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.junit.rules.RuleChain.outerRule;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.PollingProber;

import com.mulesoft.anypoint.tests.DescriptiveProbe;
import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.anypoint.tests.infrastructure.rules.FakeApiServerRule;
import com.mulesoft.anypoint.tests.rules.HttpServerRule;
import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.rules.RuleChain;

public class AbstractAnalyticsTestCase extends AbstractMuleTestCase {

  public static final String USER_AGENT = "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.0.12)";

  protected static final ApiKey EMPTY_API_KEY = new ApiKey(1L);
  protected static final ApiKey ERROR_API_KEY = new ApiKey(2L);
  protected static final ApiKey RESPONSE_API_KEY = new ApiKey(3L);
  protected static final ApiKey EXPLICIT_CL_API_KEY = new ApiKey(4L);
  protected static final ApiKey PROXY_API_KEY = new ApiKey(5L);

  protected static final String EMPTY_EXCHANGE_NAME = "emptyExchangeName";
  protected static final String EMPTY_INSTANCE_NAME = "emptyInstanceName";
  protected static final String EMPTY_API_VERSION = "1.0.0";

  protected static final PolicyTemplateKey ERROR_BEFORE_FLOW_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "errorBefore", "0.1.0");
  protected static final PolicyTemplateKey ERROR_BEFORE_FLOW_TEMPLATE_KEY_VIOLATION_CATEGORY2 =
      new PolicyTemplateKey(GROUP_ID, "errorBefore2", "0.1.0");
  protected static final PolicyTemplateKey ERROR_AFTER_FLOW_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "errorAfter", "0.1.0");
  protected static final PolicyTemplateKey ERROR_PROPAGATE_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "errorPropagate", "0.1.0");
  protected static final PolicyTemplateKey NO_ERROR_HANDLER_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "noErrorHandler", "0.1.0");
  protected static final PolicyTemplateKey SET_STATUS_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "setStatus", "0.1.0");
  protected static final PolicyTemplateKey SET_STATUS_ON_ERROR_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "setStatusTemplateKey", "0.1.0");
  protected static final PolicyTemplateKey WITH_CLIENT_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "withClient", "0.1.0");
  protected static final PolicyTemplateKey NO_EXECUTE_NEXT_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "noExecuteNext", "0.1.0");

  protected static Artifact application = buildTestApplication(APP, "mule-config-http.xml");

  protected static FakeGatewayInstallation installation =
      builder()
          .withApplications(application)
          .withPolicyTemplates(buildTestPolicyTemplate(POLICY_TEMPLATE_KEY, "policy-template.xml", "/spec.yaml"),
                               buildTestPolicyTemplate(NO_EXECUTE_NEXT_TEMPLATE_KEY, "policy-no-execute-next.xml", "/spec.yaml"),
                               buildTestPolicyTemplate(ERROR_BEFORE_FLOW_TEMPLATE_KEY, "policy-template-error-before-flow.xml",
                                                       "/spec.yaml"),
                               buildTestPolicyTemplate(ERROR_BEFORE_FLOW_TEMPLATE_KEY_VIOLATION_CATEGORY2,
                                                       "policy-template-error-before-flow.xml",
                                                       "/spec2.yaml"),
                               buildTestPolicyTemplate(ERROR_AFTER_FLOW_TEMPLATE_KEY, "policy-template-error-after-flow.xml",
                                                       "/spec.yaml"),
                               buildTestPolicyTemplate(ERROR_PROPAGATE_TEMPLATE_KEY, "policy-template-error-propagate.xml",
                                                       "/spec.yaml"),
                               buildTestPolicyTemplate(NO_ERROR_HANDLER_TEMPLATE_KEY, "policy-template-no-error-handler.xml",
                                                       "/spec.yaml"),
                               buildTestPolicyTemplate(SET_STATUS_TEMPLATE_KEY, "policy-template-set-status-code.xml",
                                                       "/spec.yaml"),
                               buildTestPolicyTemplate(SET_STATUS_ON_ERROR_TEMPLATE_KEY,
                                                       "policy-template-set-status-code-on-error.xml", "/spec.yaml"),
                               buildTestPolicyTemplate(WITH_CLIENT_TEMPLATE_KEY, "policy-with-client.xml", "/spec.yaml",
                                                       testAuthenticationDependency()))
          .analyticsEnabled()
          .gateKeeperDisabled()
          .build();

  protected static HttpServerRule backendServer = new HttpServerRule("backendPort");

  protected static final String RESPONSE_PAYLOAD = "GeitWeii Team";

  private static DynamicPort apiPort = new DynamicPort("apiPort");
  private static DynamicPort httpPort = new DynamicPort("port");
  private static FakeApiServerRule fakeApiServer = new FakeApiServerRule(apiPort.getNumber(), true);

  static {
    fakeModel().createApi(EMPTY_API_KEY.id(), EMPTY_INSTANCE_NAME, EMPTY_API_VERSION, EMPTY_EXCHANGE_NAME);
    fakeModel().createApi(ERROR_API_KEY.id());
    fakeModel().createApi(RESPONSE_API_KEY.id());
    fakeModel().createApi(EXPLICIT_CL_API_KEY.id());
    fakeModel().createApi(PROXY_API_KEY.id());
  }

  protected HttpRequest emptyRequest = request(httpPort.getNumber(), "/api/empty");
  protected HttpRequest errorRequest = request(httpPort.getNumber(), "/api/error");
  protected HttpRequest noApiRequest = request(httpPort.getNumber(), "/api/no-api");
  protected HttpRequest responseRequest = request(httpPort.getNumber(), "/api/response");
  protected HttpRequest explicitClRequest = request(httpPort.getNumber(), "/api/explicit-cl");
  protected HttpRequest proxyRequest = request(httpPort.getNumber(), "/api/proxy");

  protected static RuleChain getChain(boolean includeAnalyticsUri) {
    return getChain(includeAnalyticsUri, 1);
  }

  protected static RuleChain getChain(boolean includeAnalyticsUri, Integer pushFreq) {
    return getChain(includeAnalyticsUri, pushFreq, false);
  }

  protected static RuleChain getChain(boolean includeAnalyticsUri, Integer pushFreq, boolean serviceMeshMode) {
    String analyticsUri = includeAnalyticsUri ? "http://localhost:" + apiPort.getNumber() + "/test" : "";
    return outerRule(httpPort)
        .around(new SystemProperty("anypoint.platform.base_uri", "http://localhost:" + apiPort.getNumber() + "/test"))
        .around(new SystemProperty("anypoint.platform.analytics_base_uri", analyticsUri))
        .around(new SystemProperty("anypoint.platform.analytics_policy_violations_push_freq", pushFreq.toString()))
        .around(new SystemProperty("anypoint.platform.analytics_push_freq", pushFreq.toString()))
        .around(new SystemProperty("anypoint.platform.analytics_mode", serviceMeshMode ? "service_mesh" : "classic"))
        .around(new SystemProperty("responsePayload", RESPONSE_PAYLOAD))
        .around(backendServer)
        .around(apiPort)
        .around(fakeApiServer)
        .around(installation);
  }

  @AfterClass
  public static void afterClass() {
    fakeModel().clear();
  }

  @Before
  public void assertApisTracked() {
    installation.getServer().assertApiTracked(EMPTY_API_KEY);
    installation.getServer().assertApiTracked(ERROR_API_KEY);
    installation.getServer().assertApiTracked(RESPONSE_API_KEY);
    installation.getServer().assertApiTracked(EXPLICIT_CL_API_KEY);
    installation.getServer().assertApiTracked(PROXY_API_KEY);
  }

  protected void probe(Runnable asserter) {
    descriptiveCountProber(100, 300, asserter);
  }


}
