/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.analytics;

import static com.mulesoft.mule.runtime.gw.analytics.AnalyticsCoreExtension.ANALYTICS_POLICY_VIOLATION_QUEUE;
import static com.mulesoft.mule.runtime.gw.analytics.AnalyticsCoreExtension.ANALYTICS_QUEUE;
import static com.mulesoft.mule.runtime.gw.api.analytics.GatewayAnalytics.GW_ANALYTICS_REGISTRY_KEY;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;

import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCache;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.analytics.GatewayAnalytics;

import java.util.Optional;
import java.util.Queue;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class AnalyticsExternalApiTestCase extends AbstractAnalyticsTestCase {

  @ClassRule
  public static RuleChain chain = getChain(false);

  @Test
  public void analyticsEventIsExposed() throws ClassNotFoundException {
    Class<?> clazz =
        installation
            .getServer()
            .findApplication(application.getName())
            .getArtifactClassLoader()
            .getClassLoader()
            .loadClass(AnalyticsHttpEvent.class.getName());

    assertThat(clazz, notNullValue());
  }

  @Test
  public void analyticsStatusApiAvailableInRegistry() {
    Optional<GatewayAnalytics> gatewayAnalytics =
        installation.getServer().findApplication(application.getName()).getRegistry().lookupByName(GW_ANALYTICS_REGISTRY_KEY);

    assertThat(gatewayAnalytics, notNullValue());
  }

  @Test
  public void analyticsQueueAvailableInRegistry() {
    Queue<AnalyticsHttpEvent> queue = getQueue(ANALYTICS_QUEUE);
    Queue<AnalyticsHttpEvent> violationsQueue = getQueue(ANALYTICS_POLICY_VIOLATION_QUEUE);

    assertThat(queue, instanceOf(AnalyticsEventCache.class));
    assertThat(violationsQueue, instanceOf(AnalyticsEventCache.class));
  }

  private Queue<AnalyticsHttpEvent> getQueue(String queueName) {
    return installation.getServer().findApplication(application.getName()).getRegistry().<Queue>lookupByName(queueName)
        .get();
  }

}
