/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.analytics;

import static com.mulesoft.anypoint.analytics.asserter.AnalyticsEventAsserter.asserter;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.infrastructure.model.FakeApiModel.fakeModel;
import static java.util.Collections.emptyMap;
import static javax.ws.rs.HttpMethod.GET;
import static org.hamcrest.Matchers.hasSize;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;

import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class AnalyticsNoExecuteNextTestCase extends AbstractAnalyticsTestCase {

  @ClassRule
  public static RuleChain chain = getChain(true);

  @Before
  public void setUp() {
    PolicyDefinition policy = new PolicyDefinition(POLICY_ID, NO_EXECUTE_NEXT_TEMPLATE_KEY, EMPTY_API_KEY, null, 1,
                                                   new PolicyConfiguration(emptyMap()));
    installation.getServer().getPolicyDeploymentService()
        .newPolicy(policy);
    emptyRequest.withHeader("User-Agent", USER_AGENT);
  }

  @After
  public void tearDown() {
    fakeModel().clearEvents();
    installation.removePoliciesAndContext();
    emptyRequest.cleanHeaders();
  }

  @Test
  public void getMethod() {
    assertEquals(200, emptyRequest.get().statusCode());

    probe(() -> {
      assertThat(fakeModel().getEvents(), hasSize(1));

      asserter()
          .methodIs(GET)
          .pathIs("/api/empty")
          .statusCodeIs(200)
          .execute(fakeModel().getFirstEvent());
    });
  }

}
