/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.analytics;

import static com.mulesoft.anypoint.analytics.asserter.AnalyticsEventAsserter.asserter;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.infrastructure.model.FakeApiModel.fakeModel;
import static java.util.Collections.emptyMap;
import static javax.ws.rs.HttpMethod.GET;
import static javax.ws.rs.HttpMethod.POST;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasSize;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;

import com.mulesoft.anypoint.tests.infrastructure.model.FakeHttpEvent;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(Parameterized.class)
public class AnalyticsTestCase extends AbstractAnalyticsTestCase {

  @ClassRule
  public static RuleChain chain = getChain(true);

  private final boolean deployPolicy;

  public AnalyticsTestCase(boolean deployPolicy) {
    this.deployPolicy = deployPolicy;
  }

  @Parameterized.Parameters
  public static Collection<Object[]> data() {
    return Arrays.asList(new Object[][] {
        {false},
        {true}
    });
  }

  @Before
  public void setUp() {
    if (deployPolicy) {
      PolicyDefinition emptyApiPolicy =
          new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, EMPTY_API_KEY, null, 1, new PolicyConfiguration(emptyMap()));
      PolicyDefinition errorApiPolicy =
          new PolicyDefinition(POLICY_ID_2, POLICY_TEMPLATE_KEY, ERROR_API_KEY, null, 1, new PolicyConfiguration(emptyMap()));

      installation.getServer().deployPolicy(emptyApiPolicy);
      installation.getServer().deployPolicy(errorApiPolicy);
    }

  }

  @After
  public void tearDown() {
    fakeModel().clearEvents();
    installation.removePoliciesAndContext();
  }

  @Test
  public void getMethod() {
    assertEquals(201, emptyRequest.withHeader("User-Agent", USER_AGENT).get().statusCode());

    probe(() -> {
      assertThat(fakeModel().getEvents(), hasSize(1));

      asserter()
          .methodIs(GET)
          .pathIs("/api/empty")
          .statusCodeIs(201)
          .requestBytesAre(0)
          .responseBytesAre(0)
          .execute(fakeModel().getFirstEvent());
    });
  }

  @Test
  public void postMethod() {
    String testPayload = "some body";
    assertEquals(201, emptyRequest.withHeader("User-Agent", USER_AGENT).withPayload(testPayload).post().statusCode());

    probe(() -> {
      assertThat(fakeModel().getEvents(), hasSize(1));

      asserter()
          .methodIs(POST)
          .pathIs("/api/empty")
          .statusCodeIs(201)
          .responseBytesAre(testPayload.length())
          .requestBytesAre(testPayload.length())
          .execute(fakeModel().getFirstEvent());
    });
  }

  @Test
  public void errorInFlow() {
    assertEquals(502, errorRequest.withHeader("User-Agent", USER_AGENT).get().statusCode());

    probe(() -> {
      assertThat(fakeModel().getEvents(), hasSize(1));

      asserter()
          .methodIs(GET)
          .pathIs("/api/error")
          .statusCodeIs(502)
          .execute(fakeModel().getFirstEvent());
    });
  }

  @Test
  public void multipleEvents() {
    assertEquals(201, emptyRequest.withHeader("User-Agent", USER_AGENT).get().statusCode());
    assertEquals(201, emptyRequest.withHeader("User-Agent", USER_AGENT).get().statusCode());
    assertEquals(502, errorRequest.withHeader("User-Agent", USER_AGENT).get().statusCode());

    probe(() -> {
      assertThat(fakeModel().getEvents(), hasSize(3));

      Iterator<FakeHttpEvent> iterator = fakeModel().getEvents().iterator();
      assertEquals(201, iterator.next().getStatusCode());
      assertEquals(201, iterator.next().getStatusCode());
      assertEquals(502, iterator.next().getStatusCode());
    });
  }

}
