/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.servers;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.sun.net.httpserver.HttpExchange;
import java.io.InputStream;
import java.util.Set;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;

public class GwHttpMessage {
    private byte[] body = new byte[0];
    private String uri;
    private MultiMap queryParams;
    private Multimap<String, String> headers = ImmutableMultimap.builder().build();

    public GwHttpMessage(HttpExchange httpExchange) {
        this.body = IOUtils.toByteArray((InputStream)httpExchange.getRequestBody());
        ImmutableMultimap.Builder headersBuilder = ImmutableMultimap.builder();
        Set<String> headerNames = httpExchange.getRequestHeaders().keySet();
        headerNames.stream().forEach(headerName -> headersBuilder.putAll(headerName, (Iterable)httpExchange.getRequestHeaders().get(headerName)));
        this.headers = headersBuilder.build();
        this.uri = httpExchange.getRequestURI().getPath();
        this.queryParams = this.queryToMap(httpExchange.getRequestURI().getQuery());
    }

    public byte[] getBody() {
        return this.body;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public String getUri() {
        return this.uri;
    }

    private MultiMap<String, String> queryToMap(String query) {
        MultiMap result = new MultiMap();
        if (query == null) {
            return result;
        }
        for (String param : query.split("&")) {
            String[] pair = param.split("=");
            if (pair.length > 1) {
                result.put((Object)pair[0], (Object)pair[1]);
                continue;
            }
            result.put((Object)pair[0], (Object)"");
        }
        return result;
    }
}

