/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.servers;

import com.mulesoft.anypoint.tests.infrastructure.servers.GwHttpMessage;
import com.mulesoft.anypoint.tests.infrastructure.servers.GwHttpServerResponse;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;

public class GwHttpServer {
    private final int port;
    private HttpServer server;
    private LinkedList<GwHttpMessage> httpRequests = new LinkedList();
    private GwHttpServerResponse response = new GwHttpServerResponse();

    private GwHttpServer(int port) {
        this.port = port;
    }

    public static GwHttpServer createServer(int port) {
        return new GwHttpServer(port);
    }

    public List<GwHttpMessage> getAllHttpRequests() {
        return new LinkedList<GwHttpMessage>(this.httpRequests);
    }

    public GwHttpMessage getLastHttpRequest() {
        return this.httpRequests.getLast();
    }

    public int getPort() {
        return this.port;
    }

    public void setResponse(GwHttpServerResponse response) {
        this.response = response;
    }

    public GwHttpServer start() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.createContext("/", new TestHandler());
            this.server.setExecutor(null);
            this.server.start();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.server.stop(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        this.httpRequests.clear();
    }

    class TestHandler
    implements HttpHandler {
        TestHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            GwHttpServer.this.httpRequests.addLast(new GwHttpMessage(exchange));
            Headers headers = exchange.getResponseHeaders();
            GwHttpServer.this.response.getHeaders().forEach(headers::add);
            exchange.sendResponseHeaders(GwHttpServer.this.response.getStatusCode(), GwHttpServer.this.response.getContentLength());
            OutputStream os = exchange.getResponseBody();
            os.write(GwHttpServer.this.response.getBody());
            os.flush();
            os.close();
        }
    }
}

