/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.servers;

import com.mulesoft.anypoint.tests.http.HttpResponseBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class GwHttpServerResponse {
    private byte[] body = new byte[0];
    private Map<String, String> headers = new HashMap<String, String>();
    private int statusCode = 200;
    private boolean chunked;

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getContentLength() {
        return this.chunked ? 0 : this.body.length;
    }

    public static class Builder
    implements HttpResponseBuilder<Builder> {
        private GwHttpServerResponse response = new GwHttpServerResponse();

        public Builder statusCode(int statusCode) {
            this.response.statusCode = statusCode;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.response.headers.put(key, value);
            return this;
        }

        public Builder body(String body) {
            this.response.body = body.getBytes();
            return this;
        }

        public Builder body(byte[] body) {
            this.response.body = body;
            return this;
        }

        public Builder body(File file) {
            try {
                this.response.body = IOUtils.toByteArray((InputStream)new FileInputStream(file));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder chunked(boolean chunked) {
            this.response.chunked = chunked;
            return this;
        }

        public GwHttpServerResponse build() {
            return this.response;
        }
    }
}

