/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallationConfiguration.GatewayMode.ONLINE;
import static com.mulesoft.anypoint.tests.infrastructure.installation.JdbcStoreConfiguration.JDBC_STORE_DRIVER_PROPERTY;
import static com.mulesoft.anypoint.tests.infrastructure.installation.JdbcStoreConfiguration.JDBC_STORE_PASSWORD_PROPERTY;
import static com.mulesoft.anypoint.tests.infrastructure.installation.JdbcStoreConfiguration.JDBC_STORE_QUERY_STRATEGY_PROPERTY;
import static com.mulesoft.anypoint.tests.infrastructure.installation.JdbcStoreConfiguration.JDBC_STORE_URL_PROPERTY;
import static com.mulesoft.anypoint.tests.infrastructure.installation.JdbcStoreConfiguration.JDBC_STORE_USERNAME_PROPERTY;
import static com.mulesoft.anypoint.tests.infrastructure.model.FakeApiServer.CLIENT_ID;
import static com.mulesoft.anypoint.tests.infrastructure.model.FakeApiServer.CLIENT_SECRET;
import static com.mulesoft.anypoint.tita.environment.maven.MavenInstallation.getMavenLocalRepository;
import static java.lang.System.clearProperty;
import static java.lang.System.setProperty;

import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode;
import com.mulesoft.mule.runtime.gw.api.config.OnApiDeletedConfiguration;

import org.junit.rules.ExternalResource;

public class FakeGatewayInstallationConfiguration extends ExternalResource {

  private static final String ENCRYPTED_CLIENT_ID = "+DwMuS131Rb4Oj5Pzcm+Ig==";
  private static final String ENCRYPTED_CLIENT_SECRET = "vmvQ9p1JnpUudW1byQyUFg==";

  private final GatewayMode gatewayMode;
  private final boolean encrypted;
  private final Mode gateKeeper;
  private final JdbcStoreConfiguration jdbcStoreConfiguration;
  private final OnApiDeletedConfiguration.Mode onApiDeleted;

  public FakeGatewayInstallationConfiguration(GatewayMode gatewayMode, boolean encrypted, Mode gateKeeper,
                                              OnApiDeletedConfiguration.Mode onApiDeleted) {
    this(gatewayMode, encrypted, gateKeeper, null, onApiDeleted);
  }

  public FakeGatewayInstallationConfiguration(GatewayMode gatewayMode, boolean encrypted, Mode gateKeeper,
                                              JdbcStoreConfiguration jdbcStoreConfiguration,
                                              OnApiDeletedConfiguration.Mode onApiDeleted) {
    this.gatewayMode = gatewayMode;
    this.encrypted = encrypted;
    this.gateKeeper = gateKeeper;
    this.jdbcStoreConfiguration = jdbcStoreConfiguration;
    this.onApiDeleted = onApiDeleted;
  }

  @Override
  protected void before() {
    setProperty("muleRuntimeConfig.maven.repositoryLocation", getMavenLocalRepository().getAbsolutePath());
    setProperty("anypoint.platform.gatekeeper", gateKeeper.name());
    setProperty("anypoint.platform.policies.on_api_deleted", onApiDeleted.name());

    if (gatewayMode.equals(ONLINE)) {
      if (encrypted) {
        setProperty("anypoint.platform.client_id", "![" + ENCRYPTED_CLIENT_ID + "]");
        setProperty("anypoint.platform.client_secret", "![" + ENCRYPTED_CLIENT_SECRET + "]");
      } else {
        setProperty("anypoint.platform.client_id", CLIENT_ID);
        setProperty("anypoint.platform.client_secret", CLIENT_SECRET);
      }
    }

    if (jdbcStoreConfiguration != null) {
      setProperty(JDBC_STORE_URL_PROPERTY, jdbcStoreConfiguration.getJdbcStoreUrl());
      setProperty(JDBC_STORE_QUERY_STRATEGY_PROPERTY, jdbcStoreConfiguration.getJdbcStoreQueryStrategy());
      setProperty(JDBC_STORE_DRIVER_PROPERTY, jdbcStoreConfiguration.getJdbcStoreDriver());
      setProperty(JDBC_STORE_USERNAME_PROPERTY, jdbcStoreConfiguration.getJdbcStoreUsername());
      setProperty(JDBC_STORE_PASSWORD_PROPERTY, jdbcStoreConfiguration.getJdbcStorePassword());
    }

  }

  @Override
  protected void after() {
    clearProperty("muleRuntimeConfig.maven.repositoryLocation");
    clearProperty("anypoint.platform.gatekeeper");
    clearProperty("anypoint.platform.policies.on_api_deleted");

    if (gatewayMode.equals(ONLINE)) {
      clearProperty("anypoint.platform.client_id");
      clearProperty("anypoint.platform.client_secret");
    }

    if (jdbcStoreConfiguration != null) {
      clearProperty(JDBC_STORE_URL_PROPERTY);
      clearProperty(JDBC_STORE_DRIVER_PROPERTY);
      clearProperty(JDBC_STORE_USERNAME_PROPERTY);
      clearProperty(JDBC_STORE_PASSWORD_PROPERTY);
    }

  }

  public enum GatewayMode {
    ONLINE, OFFLINE, DISABLED
  }
}
