/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure;

import com.mulesoft.anypoint.tests.DescriptiveProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.tck.report.ThreadDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountProber
implements Prober {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingProber.class);
    public static final int DEFAULT_COUNT = 10;
    public static final long DEFAULT_POLLING_INTERVAL = 100L;
    private final int count;
    private final long pollDelayMillis;

    public CountProber() {
        this(10, 100L);
    }

    public CountProber(int count) {
        this(count, 100L);
    }

    public CountProber(int count, long pollDelayMillis) {
        this.count = count;
        this.pollDelayMillis = pollDelayMillis;
    }

    public static void descriptiveCountProber(int count, Runnable asserter) {
        new CountProber(count).check((Probe)new DescriptiveProbe(asserter));
    }

    public static void descriptiveCountProber(int count, int delayMillis, Runnable asserter) {
        new CountProber(count, delayMillis).check((Probe)new DescriptiveProbe(asserter));
    }

    public void check(Probe probe) {
        if (!this.poll(probe)) {
            LOGGER.error("test timed out. Maybe due to a deadlock?");
            if (LOGGER.isTraceEnabled()) {
                ThreadDumper.logThreadDump();
            }
            throw new AssertionError((Object)probe.describeFailure());
        }
    }

    private boolean poll(Probe probe) {
        for (int i = 0; i < this.count; ++i) {
            if (probe.isSatisfied()) {
                return true;
            }
            this.waitFor(this.pollDelayMillis);
        }
        return false;
    }

    private void waitFor(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("unexpected interrupt", e);
        }
    }
}

