/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import static com.hazelcast.core.Hazelcast.newHazelcastInstance;

import com.mulesoft.mule.runtime.module.cluster.internal.ClusterSupportProperties;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;

import org.junit.rules.ExternalResource;

/**
 * Starts a Hazelcast Server, ideal for testing a MULE Cluster with client mode enabled
 */
public class HazelcastServer extends ExternalResource {

  private HazelcastInstance hazelcastServer;

  @Override
  protected void before() throws Throwable {
    try {
      System.setProperty(ClusterSupportProperties.CLUSTER_CLIENT_MODE, "true");
      System.setProperty(ClusterSupportProperties.CLUSTER_NODES_IP, "127.0.0.1");
      System.setProperty(ClusterSupportProperties.CLUSTER_NODE_ID_PROPERTY_KEY, "hazelcastserver");
      Config configService = new Config("hazelcastserver");
      configService.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
      configService.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true).addMember("127.0.0.1");
      hazelcastServer = newHazelcastInstance(configService);
    } finally {
      System.clearProperty(ClusterSupportProperties.CLUSTER_CLIENT_MODE);
      System.clearProperty(ClusterSupportProperties.CLUSTER_NODES_IP);
      System.clearProperty(ClusterSupportProperties.CLUSTER_NODE_ID_PROPERTY_KEY);
    }
  }

  @Override
  protected void after() {
    if (hazelcastServer != null) {
      hazelcastServer.shutdown();
      hazelcastServer = null;
    }
  }

}
