/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import static com.google.common.collect.Lists.newArrayList;

import com.mulesoft.mule.runtime.module.cluster.internal.ClusterSupportProperties;

import java.util.UUID;

import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;

public class ClusterSystemProperties extends ExternalResource {

  private static final String LOCALHOST_IP = "127.0.0.1";

  private final int clusterSize;
  private final boolean clientMode;

  public ClusterSystemProperties(int clusterSize) {
    this(clusterSize, false);
  }

  public ClusterSystemProperties(int clusterSize, boolean clientMode) {
    this.clusterSize = clusterSize;
    this.clientMode = clientMode;
  }

  @Override
  protected void before() throws Exception {
    System.setProperty(ClusterSupportProperties.CLUSTER_ID_PROPERTY_KEY, UUID.randomUUID().toString());
    System.setProperty(ClusterSupportProperties.CLUSTER_SIZE_PROPERTY_KEY, String.valueOf(clusterSize));
    System.setProperty(ClusterSupportProperties.MULTICAST_ENABLED, "false");
    System.setProperty(ClusterSupportProperties.NETWORK_INTERFACES_PROP, LOCALHOST_IP);
    System.setProperty(ClusterSupportProperties.CLUSTER_NODES_IP, StringUtils.join(newArrayList(LOCALHOST_IP), ","));
    System.setProperty(ClusterSupportProperties.CLUSTER_NODE_ID_PROPERTY_KEY, "1");
    System.setProperty(ClusterSupportProperties.CLUSTER_CLIENT_MODE, String.valueOf(clientMode));
  }

  @Override
  protected void after() {
    System.clearProperty(ClusterSupportProperties.CLUSTER_ID_PROPERTY_KEY);
    System.clearProperty(ClusterSupportProperties.CLUSTER_SIZE_PROPERTY_KEY);
    System.clearProperty(ClusterSupportProperties.MULTICAST_ENABLED);
    System.clearProperty(ClusterSupportProperties.NETWORK_INTERFACES_PROP);
    System.clearProperty(ClusterSupportProperties.CLUSTER_NODES_IP);
    System.clearProperty(ClusterSupportProperties.CLUSTER_NODE_ID_PROPERTY_KEY);
    System.clearProperty(ClusterSupportProperties.CLUSTER_CLIENT_MODE_CLUSTER_ID);
    System.clearProperty(ClusterSupportProperties.CLUSTER_CLIENT_MODE_CLUSTER_PASSWORD);
    System.clearProperty(ClusterSupportProperties.CLUSTER_CLIENT_MODE);
  }

  public void updateClusterNodeIdProperty(String nodeId) {
    System.setProperty(ClusterSupportProperties.CLUSTER_NODE_ID_PROPERTY_KEY, nodeId);
  }

}
