/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import static java.lang.String.format;

import java.sql.SQLException;

import org.h2.tools.Server;
import org.junit.rules.ExternalResource;

public class H2DataBase extends ExternalResource implements JdbcStoreConfiguration {

  public static final String DRIVER = "org.h2.Driver";

  private final Server server;
  private int port;

  public H2DataBase(int port) {
    this.port = port;
    try {
      Class.forName(DRIVER); // Load driver
      server = Server.createTcpServer("-tcpPort", Integer.toString(port), "-tcpAllowOthers", "-tcpDaemon");
    } catch (ClassNotFoundException | SQLException e) {
      throw new RuntimeException(e);
    }
  }

  @Override
  protected void before() throws Throwable {
    server.start();
  }

  @Override
  protected void after() {
    server.stop();
    server.shutdown();
  }

  public String getJdbcStoreUrl() {
    return format("jdbc:h2:mem:tcp://localhost:%d/test", port);
  }

  public String getJdbcStoreQueryStrategy() {
    return "default";
  }

  public String getJdbcStoreDriver() {
    return DRIVER;
  }

  public String getJdbcStoreUsername() {
    return "user";
  }

  public String getJdbcStorePassword() {
    return "pass";
  }
}
