/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import com.mulesoft.anypoint.tests.infrastructure.installation.JdbcStoreConfiguration;
import java.sql.SQLException;
import org.h2.tools.Server;
import org.junit.rules.ExternalResource;

public class H2DataBase
extends ExternalResource
implements JdbcStoreConfiguration {
    public static final String DRIVER = "org.h2.Driver";
    private final Server server;
    private int port;

    public H2DataBase(int port) {
        this.port = port;
        try {
            Class.forName(DRIVER);
            this.server = Server.createTcpServer((String[])new String[]{"-tcpPort", Integer.toString(port), "-tcpAllowOthers", "-tcpDaemon"});
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void before() throws Throwable {
        this.server.start();
    }

    protected void after() {
        this.server.stop();
        this.server.shutdown();
    }

    @Override
    public String getJdbcStoreUrl() {
        return String.format("jdbc:h2:mem:tcp://localhost:%d/test", this.port);
    }

    @Override
    public String getJdbcStoreQueryStrategy() {
        return "default";
    }

    @Override
    public String getJdbcStoreDriver() {
        return DRIVER;
    }

    @Override
    public String getJdbcStoreUsername() {
        return "user";
    }

    @Override
    public String getJdbcStorePassword() {
        return "pass";
    }
}

