/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import com.mulesoft.anypoint.tests.infrastructure.installation.JdbcStoreConfiguration;
import com.mulesoft.anypoint.tita.environment.maven.MavenInstallation;
import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.OnApiDeletedConfiguration;
import org.junit.rules.ExternalResource;

public class FakeGatewayInstallationConfiguration
extends ExternalResource {
    private static final String ENCRYPTED_CLIENT_ID = "+DwMuS131Rb4Oj5Pzcm+Ig==";
    private static final String ENCRYPTED_CLIENT_SECRET = "vmvQ9p1JnpUudW1byQyUFg==";
    private final GatewayMode gatewayMode;
    private final boolean encrypted;
    private final String encryptionKey;
    private final GateKeeperConfiguration.Mode gateKeeper;
    private final JdbcStoreConfiguration jdbcStoreConfiguration;
    private final OnApiDeletedConfiguration.Mode onApiDeleted;

    public FakeGatewayInstallationConfiguration(GatewayMode gatewayMode, boolean encrypted, String encryptionKey, GateKeeperConfiguration.Mode gateKeeper, OnApiDeletedConfiguration.Mode onApiDeleted) {
        this(gatewayMode, encrypted, encryptionKey, gateKeeper, null, onApiDeleted);
    }

    public FakeGatewayInstallationConfiguration(GatewayMode gatewayMode, boolean encrypted, String encryptionKey, GateKeeperConfiguration.Mode gateKeeper, JdbcStoreConfiguration jdbcStoreConfiguration, OnApiDeletedConfiguration.Mode onApiDeleted) {
        this.gatewayMode = gatewayMode;
        this.encrypted = encrypted;
        this.encryptionKey = encryptionKey;
        this.gateKeeper = gateKeeper;
        this.jdbcStoreConfiguration = jdbcStoreConfiguration;
        this.onApiDeleted = onApiDeleted;
    }

    protected void before() {
        System.setProperty("muleRuntimeConfig.maven.repositoryLocation", MavenInstallation.getMavenLocalRepository().getAbsolutePath());
        System.setProperty("anypoint.platform.gatekeeper", this.gateKeeper.name());
        System.setProperty("anypoint.platform.policies.on_api_deleted", this.onApiDeleted.name());
        if (this.gatewayMode.equals((Object)GatewayMode.ONLINE)) {
            if (this.encrypted) {
                System.setProperty("anypoint.platform.client_id", "![+DwMuS131Rb4Oj5Pzcm+Ig==]");
                System.setProperty("anypoint.platform.client_secret", "![vmvQ9p1JnpUudW1byQyUFg==]");
            } else {
                System.setProperty("anypoint.platform.client_id", "cc_client");
                System.setProperty("anypoint.platform.client_secret", "zFederate");
            }
        }
        if (this.encryptionKey != null) {
            System.setProperty("anypoint.platform.encryption_key", this.encryptionKey);
        }
        if (this.jdbcStoreConfiguration != null) {
            System.setProperty("mule.cluster.jdbcstoreurl", this.jdbcStoreConfiguration.getJdbcStoreUrl());
            System.setProperty("mule.cluster.jdbcstorequerystrategy", this.jdbcStoreConfiguration.getJdbcStoreQueryStrategy());
            System.setProperty("mule.cluster.jdbcstoredriver", this.jdbcStoreConfiguration.getJdbcStoreDriver());
            System.setProperty("mule.cluster.jdbcstoreusername", this.jdbcStoreConfiguration.getJdbcStoreUsername());
            System.setProperty("mule.cluster.jdbcstorepassword", this.jdbcStoreConfiguration.getJdbcStorePassword());
        }
    }

    protected void after() {
        System.clearProperty("muleRuntimeConfig.maven.repositoryLocation");
        System.clearProperty("anypoint.platform.gatekeeper");
        System.clearProperty("anypoint.platform.policies.on_api_deleted");
        if (this.gatewayMode.equals((Object)GatewayMode.ONLINE)) {
            System.clearProperty("anypoint.platform.client_id");
            System.clearProperty("anypoint.platform.client_secret");
        }
        if (this.encryptionKey != null) {
            System.clearProperty("anypoint.platform.encryption_key");
        }
        if (this.jdbcStoreConfiguration != null) {
            System.clearProperty("mule.cluster.jdbcstoreurl");
            System.clearProperty("mule.cluster.jdbcstoredriver");
            System.clearProperty("mule.cluster.jdbcstoreusername");
            System.clearProperty("mule.cluster.jdbcstorepassword");
        }
    }

    public static enum GatewayMode {
        ONLINE,
        OFFLINE,
        DISABLED;

    }
}

