/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure;

import com.google.common.collect.ImmutableList;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.tests.DescriptiveProbe;
import com.mulesoft.anypoint.tests.infrastructure.exception.AppDeploymentException;
import com.mulesoft.anypoint.tests.infrastructure.exception.AppUndeploymentException;
import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import com.mulesoft.anypoint.tita.environment.api.artifact.PolicyJar;
import com.mulesoft.mule.runtime.gw.api.agent.HealthCheck;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.deployment.ApiDeploymentCoreExtension;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PlatformInteractionServicesLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.ApisPollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.ClientsPlatformInteractionLifecycleAdapter;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive.KeepAlivePlatformInteractionLifecycleAdapter;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.hdp.listener.HdpDeploymentListener;
import com.mulesoft.mule.runtime.gw.metrics.GatewayMetricsAdapter;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.infrastructure.deployment.FakeMuleServer;

public class FakeGatewayServer
extends FakeMuleServer {
    private final PolicyStore policyStore;
    private final File policiesDir = this.createFolder("policies");
    private final File hdpRegistryDir = this.createFolder("policies/hdp-api-registry");
    private final String clusterId;

    public FakeGatewayServer(String muleHomePath, List<MuleCoreExtension> initialCoreExtensions, String clusterId) {
        super(muleHomePath, initialCoreExtensions);
        this.policyStore = new DefaultPolicyStore(new EncryptedPropertiesSerializer());
        this.clusterId = clusterId;
    }

    public File getPoliciesDir() {
        return this.policiesDir;
    }

    public <T extends MuleCoreExtension> T getCoreExtension(Class<T> coreExtensionClass) {
        List coreExtensions = (List)new Inspector((Object)this).read("coreExtensions");
        return (T)coreExtensions.stream().filter(c -> coreExtensionClass.isAssignableFrom(c.getClass())).findFirst().orElseThrow(() -> new IllegalArgumentException("Core Extension not present in Server"));
    }

    public DeploymentService getDeploymentService() {
        try {
            return (DeploymentService)FieldUtils.readField((Object)((Object)this), (String)"deploymentService", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public FakeGatewayServer deployApplications(Artifact ... applications) {
        ImmutableList.copyOf((Object[])applications).forEach(app -> {
            try {
                this.installApplication((Artifact)app);
                this.assertDeploymentSuccess(app.getName());
            }
            catch (AssertionError e) {
                try {
                    this.assertDeploymentSuccess(app.getName());
                }
                catch (AssertionError e2) {
                    throw new AppDeploymentException("App " + app.getName() + " could not be correctly deployed");
                }
            }
        });
        return this;
    }

    public FakeGatewayServer deployApplicationsExpectingFailure(Artifact ... applications) {
        ImmutableList.copyOf((Object[])applications).forEach(app -> {
            try {
                this.installApplication((Artifact)app);
                this.assertDeploymentFailure(app.getName());
            }
            catch (AssertionError e) {
                throw new AppDeploymentException("App " + app.getName() + " was expected to cause a deployment failure but it did not");
            }
        });
        return this;
    }

    public void installApplications(List<Artifact> applications) {
        applications.forEach(this::installApplication);
    }

    public void installDomains(List<Artifact> domains) {
        domains.forEach(this::installDomain);
    }

    private void installDomain(Artifact domain) {
        try {
            FileUtils.copyFileToDirectory((File)domain.getJarFile(), (File)new File(this.getMuleHome(), "domains"));
        }
        catch (IOException e) {
            throw new AppDeploymentException("Error copying domain jar to domains dir", e);
        }
    }

    public FakeGatewayServer undeployApplication(String appName) {
        this.resetDeploymentListener();
        Application application = this.getDeploymentService().findApplication(appName);
        File anchor = new File(application.getLocation().getAbsolutePath() + "-anchor.txt");
        if (!anchor.exists()) {
            this.undeployFailedApplication(application);
        } else if (!anchor.delete()) {
            throw new AppUndeploymentException("Error trying to delete anchor file of App " + appName);
        }
        try {
            this.assertUndeploymentSuccess(appName);
        }
        catch (AssertionError e) {
            throw new AppUndeploymentException("App " + appName + " was not correctly undeployed");
        }
        return this;
    }

    public FakeGatewayServer deployPolicy(Policy policy) {
        this.getPolicyDeploymentService().newPolicy(policy.getPolicyDefinition());
        return this;
    }

    public FakeGatewayServer deployPolicy(PolicyDefinition policyDefinition) {
        this.getPolicyDeploymentService().newPolicy(policyDefinition);
        return this;
    }

    public FakeGatewayServer deployPoliciesForApi(ApiKey apiKey, PolicySet policySet) {
        this.getPolicySetDeploymentService().policiesForApi(apiKey, policySet);
        return this;
    }

    public FakeGatewayServer undeployPolicy(String name) {
        this.getPolicyDeploymentService().removePolicy(name);
        return this;
    }

    public FakeGatewayServer removeAllPoliciesAndContext() {
        this.allPolicies().forEach(policyDefinition -> this.getPolicyDeploymentService().removePolicy(policyDefinition.getName()));
        this.cleanUpDotMule();
        return this;
    }

    public void assertApiTracked(ApiKey apiKey) {
        new PollingProber(20000L, 100L).check((Probe)new DescriptiveProbe(() -> {
            Assert.assertThat((Object)this.getApiService().get(apiKey).isPresent(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)((Api)this.getApiService().get(apiKey).get()).getTrackingInfo().isTracked(), (Matcher)CoreMatchers.is((Object)true));
        }, "API " + apiKey + " was not tracked"));
    }

    public FakeGatewayServer updateHdpRegistry(String source, String target) {
        try {
            URL sourceUri = ((Object)((Object)this)).getClass().getClassLoader().getResource(source);
            if (sourceUri == null) {
                throw new RuntimeException("Resource not found: " + source);
            }
            FileUtils.copyFile((File)new File(sourceUri.toURI()), (File)new File(this.hdpRegistryDir, target));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ContractService getContractService() {
        ServiceManager serviceManager = (ServiceManager)new Inspector((Object)this).read("serviceManager");
        return (ContractService)serviceManager.getServices().stream().filter(service -> ContractService.class.isAssignableFrom(service.getClass())).findFirst().orElseThrow(() -> new RuntimeException("Fail to get ContractService"));
    }

    public List<PolicyDefinition> allPolicies() {
        return this.policyStore.load();
    }

    public void installPolicyTemplate(PolicyJar policyTemplate) {
        File policyTemplatesFolder = new File(this.getPoliciesDir(), "policy-templates");
        if (!policyTemplatesFolder.exists() && !policyTemplatesFolder.mkdir()) {
            throw new RuntimeException("Could not create policy templates folder");
        }
        try {
            FileUtils.copyFileToDirectory((File)policyTemplate.getJarFile(), (File)policyTemplatesFolder);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy template jar file " + policyTemplate.getName(), e);
        }
        policyTemplate.getYamlFile().ifPresent(file -> {
            try {
                FileUtils.copyFile((File)file, (File)new File(policyTemplatesFolder, policyTemplate.key().getName() + ".yaml"));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy template yaml file " + policyTemplate.getName(), e);
            }
        });
    }

    public void storePolicyDefinition(PolicyDefinition policyDefinition) {
        this.policyStore.store(policyDefinition);
    }

    public PolicyFactory getPolicyFactory() {
        return (PolicyFactory)new Inspector((Object)this.getPolicySetDeploymentService()).read("policyFactory");
    }

    public PolicyDeploymentService getPolicyDeploymentService() {
        return (PolicyDeploymentService)new Inspector((Object)this.getPolicySetDeploymentService()).read("policyDeploymentService");
    }

    public PolicySetDeploymentService getPolicySetDeploymentService() {
        return (PolicySetDeploymentService)new Inspector((Object)this.getCoreExtension(ApiDeploymentCoreExtension.class)).read("policySetDeploymentService");
    }

    public ApiTrackingService getApiTrackingService() {
        return (ApiTrackingService)new Inspector((Object)this.getCoreExtension(ApiDeploymentCoreExtension.class)).read("apiTrackingService");
    }

    public ApiService getApiService() {
        return this.getCoreExtension(ApiDeploymentCoreExtension.class).getApiService();
    }

    public HdpDeploymentListener getHdpDeploymentListener() {
        return (HdpDeploymentListener)new Inspector((Object)this.getCoreExtension(ApiDeploymentCoreExtension.class)).read("hdpDeploymentListener");
    }

    public ContractSnapshots getContractSnapshots() {
        return (ContractSnapshots)new Inspector((Object)this.getCoreExtension(ApiDeploymentCoreExtension.class)).read("contractSnapshots");
    }

    public BackoffScheduler getClientsPollersManagerScheduler() {
        ApiDeploymentCoreExtension coreExtension = this.getCoreExtension(ApiDeploymentCoreExtension.class);
        return (BackoffScheduler)new Inspector((Object)coreExtension).read("platformInteractionServicesLifecycle.clientsPlatformInteractionLifecycle.lifecycle.poller.scheduler");
    }

    public BackoffScheduler getApisPollersManagerSchduler() {
        ApiDeploymentCoreExtension coreExtension = this.getCoreExtension(ApiDeploymentCoreExtension.class);
        return (BackoffScheduler)new Inspector((Object)coreExtension).read("platformInteractionServicesLifecycle.apisPlatformInteractionLifecycle.pollerLifecycle.pollerLifecycle.poller.scheduler");
    }

    public BackoffScheduler getKeepAlivePollersManagerScheduler() {
        ApiDeploymentCoreExtension coreExtension = this.getCoreExtension(ApiDeploymentCoreExtension.class);
        return (BackoffScheduler)new Inspector((Object)coreExtension).read("platformInteractionServicesLifecycle.keepAlivePlatformInteractionLifecycle.lifecycle.pollerLifecycle.poller.scheduler");
    }

    public boolean apiPollerStarted() {
        ApiDeploymentCoreExtension coreExtension = this.getCoreExtension(ApiDeploymentCoreExtension.class);
        PlatformInteractionLifecycle apisPlatformInteractionLifecycle = (PlatformInteractionLifecycle)new Inspector((Object)coreExtension).read("platformInteractionServicesLifecycle.apisPlatformInteractionLifecycle");
        return apisPlatformInteractionLifecycle instanceof ApisPollerPlatformInteractionLifecycle && this.getApisPollersManagerSchduler() != null;
    }

    public boolean keepAlivePollerStarted() {
        ApiDeploymentCoreExtension coreExtension = this.getCoreExtension(ApiDeploymentCoreExtension.class);
        PlatformInteractionLifecycle keepAlivePlatformInteractionLifecycle = (PlatformInteractionLifecycle)new Inspector((Object)coreExtension).read("platformInteractionServicesLifecycle.keepAlivePlatformInteractionLifecycle");
        return keepAlivePlatformInteractionLifecycle instanceof KeepAlivePlatformInteractionLifecycleAdapter && this.getKeepAlivePollersManagerScheduler() != null;
    }

    public boolean clientsPollerStarted() {
        ApiDeploymentCoreExtension coreExtension = this.getCoreExtension(ApiDeploymentCoreExtension.class);
        PlatformInteractionLifecycle clientsPlatformInteractionLifecycle = (PlatformInteractionLifecycle)new Inspector((Object)coreExtension).read("platformInteractionServicesLifecycle.clientsPlatformInteractionLifecycle");
        return clientsPlatformInteractionLifecycle instanceof ClientsPlatformInteractionLifecycleAdapter && this.getClientsPollersManagerScheduler() != null;
    }

    public boolean platformPollersStarted() {
        return this.apiPollerStarted() || this.keepAlivePollerStarted() || this.clientsPollerStarted();
    }

    public PlatformInteractionServicesLifecycle getPlatformInteractionLifecycle() {
        ApiDeploymentCoreExtension coreExtension = this.getCoreExtension(ApiDeploymentCoreExtension.class);
        return (PlatformInteractionServicesLifecycle)new Inspector((Object)coreExtension).read("platformInteractionServicesLifecycle");
    }

    public void forceGatewayStatusMetric() {
        ApiDeploymentCoreExtension coreExtension = this.getCoreExtension(ApiDeploymentCoreExtension.class);
        ((Optional)new Inspector((Object)coreExtension).read("metricsCollector")).ifPresent(GatewayMetricsAdapter::generateStatusEvent);
    }

    public HealthCheck getHealthCheck() {
        ApiDeploymentCoreExtension coreExtension = this.getCoreExtension(ApiDeploymentCoreExtension.class);
        return coreExtension.healthCheck();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FakeGatewayServer that = (FakeGatewayServer)((Object)o);
        return this.getMuleHome().equals(that.getMuleHome());
    }

    public int hashCode() {
        return this.getMuleHome().hashCode();
    }

    private void cleanUpDotMule() {
        File dotMule = new File(this.getMuleHome(), ".mule");
        if (dotMule.listFiles() != null) {
            Arrays.asList(dotMule.listFiles()).forEach(file -> {
                if (!this.isServicesFolder((File)file) && !this.isTemplatesFolder((File)file)) {
                    FileUtils.deleteQuietly((File)file);
                }
            });
        }
    }

    private void installApplication(Artifact app) {
        try {
            FileUtils.copyFileToDirectory((File)app.getJarFile(), (File)this.getAppsDir());
        }
        catch (IOException e) {
            throw new AppDeploymentException("Error copying app jar to apps dir", e);
        }
    }

    private boolean isTemplatesFolder(File file) {
        return file.isDirectory() && file.getName().equals("policy-templates");
    }

    private boolean isServicesFolder(File file) {
        return file.isDirectory() && file.getName().equals("services");
    }

    private File createFolder(String folderName) {
        File folder = new File(this.getMuleHome(), folderName);
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IllegalStateException(String.format("Unable to create folder '%s'", folderName));
        }
        return folder;
    }

    private void undeployFailedApplication(Application application) {
        File appFolder = new File(application.getLocation().getAbsolutePath());
        if (!appFolder.exists()) {
            throw new AppUndeploymentException("Application folder nor anchor file are present for App " + application.getArtifactName());
        }
        try {
            FileUtils.deleteDirectory((File)appFolder);
        }
        catch (IOException e) {
            throw new AppUndeploymentException("Error trying to delete app folder (anchor file was not present) of App" + application.getArtifactName(), e);
        }
    }

    public String getClusterId() {
        return this.clusterId;
    }
}

