/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServerBuilder;
import com.mulesoft.anypoint.tests.infrastructure.installation.AbstractInstallationBuilder;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallationConfiguration;
import com.mulesoft.anypoint.tests.infrastructure.installation.Installation;
import com.mulesoft.anypoint.tests.infrastructure.rules.ClusterDynamicPort;
import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.mule.runtime.api.exception.MuleException;

public class FakeGatewayInstallation
extends ExternalResource
implements Installation<FakeGatewayInstallation> {
    private Builder builder;
    private List<Artifact> applications;
    private final List<Artifact> domains;
    private final FakeGatewayInstallationConfiguration configuration;
    private FakeGatewayServer muleServer;

    public FakeGatewayInstallation(FakeGatewayServer muleServer, List<Artifact> applications, List<Artifact> domains, FakeGatewayInstallationConfiguration configuration, Builder builder) {
        this.muleServer = muleServer;
        this.applications = applications;
        this.domains = domains;
        this.configuration = configuration;
        this.builder = builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected void before() throws Throwable {
        try {
            this.muleServer.installDomains(this.domains);
            this.muleServer.installApplications(this.applications);
            this.spinUpServer();
        }
        catch (Throwable t) {
            this.after();
            throw t;
        }
    }

    protected void after() {
        this.configuration.after();
        if (this.muleServer != null) {
            try {
                this.muleServer.stop();
            }
            catch (MuleException e) {
                throw new RuntimeException("Error trying to stop Fake Mule Server", e);
            }
            finally {
                FileUtils.deleteQuietly((File)this.muleServer.getMuleHome());
            }
        }
    }

    public FakeGatewayServer getServer() {
        return this.muleServer;
    }

    @Override
    public FakeGatewayInstallation restart() {
        try {
            this.muleServer.stop();
            this.replicate(this.builder.build());
            this.spinUpServer();
        }
        catch (Exception error) {
            Assert.fail((String)this.restartMessage(error));
        }
        return this;
    }

    @Override
    public FakeGatewayInstallation removePoliciesAndContext() {
        this.muleServer.removeAllPoliciesAndContext();
        return this;
    }

    public FakeGatewayInstallation updateHdpRegistry(String source) {
        return this.updateHdpRegistry(source, source);
    }

    public FakeGatewayInstallation updateHdpRegistry(String source, String target) {
        this.muleServer.updateHdpRegistry(source, target);
        return this;
    }

    private String restartMessage(Exception onError) {
        return "Failed to restart Standalone Installation, reason: " + onError.getMessage();
    }

    private void replicate(FakeGatewayInstallation newInstallation) {
        this.muleServer = newInstallation.muleServer;
        this.applications = newInstallation.applications;
        this.builder = newInstallation.builder;
    }

    private void spinUpServer() throws IOException, MuleException {
        this.muleServer.start();
        this.applications.forEach(app -> this.muleServer.assertDeploymentSuccess(app.getName()));
    }

    public static class Builder
    extends AbstractInstallationBuilder<Builder> {
        Builder() {
            super(1, 1);
        }

        @Override
        public FakeGatewayInstallation build() {
            FakeGatewayInstallationConfiguration configuration = new FakeGatewayInstallationConfiguration(this.gatewayMode, this.encrypted, this.encryptionKey, this.gateKeeperMode, this.onApiDeleted);
            configuration.before();
            FakeGatewayServer muleServer = ((FakeGatewayServerBuilder)this.serverBuilders.get(0)).build();
            return new FakeGatewayInstallation(muleServer, this.applications, this.domains, configuration, this);
        }

        @Override
        public Builder withDynamicPort(ClusterDynamicPort dynamicPort) {
            throw new IllegalStateException("Method available only for Cluster");
        }
    }
}

