/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServerBuilder;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallationConfiguration;
import com.mulesoft.anypoint.tests.infrastructure.installation.Installation;
import com.mulesoft.anypoint.tests.infrastructure.installation.JdbcStoreConfiguration;
import com.mulesoft.anypoint.tests.infrastructure.rules.ClusterDynamicPort;
import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import com.mulesoft.anypoint.tita.environment.api.artifact.PolicyJar;
import com.mulesoft.mule.runtime.gw.analytics.AnalyticsCoreExtension;
import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.OnApiDeletedConfiguration;
import com.mulesoft.mule.runtime.gw.deployment.ApiDeploymentCoreExtension;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;

public abstract class AbstractInstallationBuilder<T extends AbstractInstallationBuilder> {
    List<FakeGatewayServerBuilder> serverBuilders = Lists.newArrayList();
    List<Artifact> applications = Lists.newArrayList();
    List<Artifact> domains = Lists.newArrayList();
    ClusterDynamicPort dynamicPort;
    FakeGatewayInstallationConfiguration.GatewayMode gatewayMode = FakeGatewayInstallationConfiguration.GatewayMode.ONLINE;
    boolean encrypted;
    String encryptionKey;
    boolean clientModeEnabled;
    GateKeeperConfiguration.Mode gateKeeperMode = GateKeeperConfiguration.Mode.STRICT;
    JdbcStoreConfiguration jdbcStoreConfiguration;
    OnApiDeletedConfiguration.Mode onApiDeleted = OnApiDeletedConfiguration.Mode.KEEP_POLICIES;

    public AbstractInstallationBuilder(int size, int numberOfGroups) {
        File baseDirectory = Files.createTempDir();
        IntStream.range(0, numberOfGroups).forEach(numberOfGroup -> {
            String clusterId = UUID.randomUUID().toString();
            IntStream.range(0, size).forEach(nodeId -> {
                FakeGatewayServerBuilder serverBuilder = new FakeGatewayServerBuilder().withMuleHome(new File(baseDirectory, this.getMuleFolderName(clusterId, nodeId)).getAbsolutePath()).clusterId(clusterId);
                this.serverBuilders.add(serverBuilder);
            });
        });
    }

    private String getMuleFolderName(String clusterId, int nodeId) {
        return clusterId + "-" + String.valueOf(nodeId);
    }

    public T withApplications(Artifact ... applications) {
        Preconditions.checkNotNull((Object)applications);
        this.applications = Arrays.asList(applications);
        return (T)this;
    }

    public AbstractInstallationBuilder<T> withDomains(Artifact ... domains) {
        Preconditions.checkNotNull((Object)domains);
        this.domains = Arrays.asList(domains);
        return this;
    }

    public T withClientModeEnabled(boolean clientModeEnabled) {
        this.clientModeEnabled = clientModeEnabled;
        return (T)this;
    }

    public T withPolicyTemplates(PolicyJar ... policyTemplates) {
        Preconditions.checkNotNull((Object)policyTemplates);
        this.serverBuilders.forEach(serverBuilder -> serverBuilder.withPolicyTemplates(policyTemplates));
        return (T)this;
    }

    public T analyticsEnabled() {
        this.serverBuilders.forEach(serverBuilder -> serverBuilder.addCoreExtension(AnalyticsCoreExtension.class));
        return (T)this;
    }

    public T offline() {
        this.gatewayMode = FakeGatewayInstallationConfiguration.GatewayMode.OFFLINE;
        return (T)this;
    }

    public T disabled() {
        this.gatewayMode = FakeGatewayInstallationConfiguration.GatewayMode.DISABLED;
        return (T)this;
    }

    public T gateKeeperDisabled() {
        this.gateKeeperMode = GateKeeperConfiguration.Mode.DISABLED;
        return (T)this;
    }

    public T withEncryptedProperties() {
        this.encrypted = true;
        return (T)this;
    }

    public T withEncryptionKey(String key) {
        this.encryptionKey = key;
        return (T)this;
    }

    public T flexibleGateKeeper() {
        this.gateKeeperMode = GateKeeperConfiguration.Mode.FLEXIBLE;
        return (T)this;
    }

    public T withJdbcStore(JdbcStoreConfiguration jdbcStoreConfiguration) {
        this.jdbcStoreConfiguration = jdbcStoreConfiguration;
        return (T)this;
    }

    public T withDynamicPort(ClusterDynamicPort dynamicPort) {
        this.dynamicPort = dynamicPort;
        return (T)this;
    }

    public T disablePolicyDeployment() {
        this.serverBuilders.forEach(serverBuilder -> serverBuilder.removeCoreExtension(ApiDeploymentCoreExtension.class));
        return (T)this;
    }

    public T withPolicyDefinitions(PolicyDefinition ... policyDefinitions) {
        this.serverBuilders.forEach(serverBuilder -> serverBuilder.withPolicyDefinitions(policyDefinitions));
        return (T)this;
    }

    public T onApiDeleted(OnApiDeletedConfiguration.Mode mode) {
        this.onApiDeleted = mode;
        return (T)this;
    }

    public abstract Installation build();
}

