/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ApiFinder {
    private final Document doc;

    public ApiFinder(String resource) {
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.loadResource("/" + resource));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public ApiKey find(String flowName) {
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile(String.format("//mule/autodiscovery[@flowRef='%s']/@apiId", flowName));
            String value = (String)expr.evaluate(this.doc, XPathConstants.STRING);
            if (value.isEmpty()) {
                throw new RuntimeException("No API found implemented by flow " + flowName);
            }
            Long id = Long.valueOf(value);
            return new ApiKey(id);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream loadResource(String resource) {
        InputStream stream = this.getClass().getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Resource not found: " + resource);
        }
        return stream;
    }
}

