/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure;

import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tita.core.maven.MavenInstallation;
import com.mulesoft.anypoint.tita.environment.api.artifact.PolicyJar;
import com.mulesoft.mule.runtime.gw.deployment.ApiDeploymentCoreExtension;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterUtils;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterCoreExtension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.internal.lock.ServerLockFactory;

public class FakeGatewayServerBuilder {
    private static final String GATEWAY_INFRASTRUCTURE = "api-gateway-tests-infrastructure";
    private static final String EE_DISTRIBUTION = "com.mulesoft.mule.distributions";
    private static final String CE_DISTRIBUTION = "org.mule.distributions";
    private static final String SERVICES_ALL = "mule-services-all";
    private static final String GATEWAY_BOM = "api-gateway-bom-impl";
    private static final String GATEWAY_SERVICES = "com.mulesoft.anypoint";
    private static final String ORG_MULE_SERVICES = "org.mule.services";
    private static final String COM_MULESOFT_MULE_SERVICES = "com.mulesoft.mule.services";
    private static final String COM_MULESOFT_SERVICES = "com.mulesoft.services";
    private static final String MULE_SERVICE_HTTP = "mule-service-http-ee";
    private static final String MULE_SERVICE_SCHEDULER = "mule-service-scheduler";
    private static final String MULE_SERVICE_WEAVE = "mule-service-weave-ee";
    private static final String GATEWAY_SERVICE_CONTRACTS = "api-gateway-contract-service";
    private static final String GATEWAY_SERVICE_EVENTS = "api-gateway-events-collector-service";
    private static final String POM = "pom";
    private String muleHome;
    private Map<Class<? extends MuleCoreExtension>, Supplier<? extends MuleCoreExtension>> coreExtensions = this.initialCoreExtensions();
    private List<PolicyJar> policyTemplates = new ArrayList<PolicyJar>();
    private List<PolicyDefinition> policyDefinitions = new ArrayList<PolicyDefinition>();
    private String clusterId = UUID.randomUUID().toString();

    public FakeGatewayServerBuilder withMuleHome(String muleHome) {
        this.muleHome = muleHome;
        return this;
    }

    public FakeGatewayServerBuilder clusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public FakeGatewayServerBuilder addCoreExtension(Class<? extends MuleCoreExtension> coreExtension) {
        this.coreExtensions.put(coreExtension, () -> this.instanceCoreExtension(coreExtension));
        return this;
    }

    public FakeGatewayServerBuilder removeCoreExtension(Class<? extends MuleCoreExtension> coreExtensionClass) {
        this.coreExtensions.remove(coreExtensionClass);
        return this;
    }

    public FakeGatewayServerBuilder withPolicyTemplates(PolicyJar ... policyTemplates) {
        this.policyTemplates = Arrays.asList(policyTemplates);
        return this;
    }

    public void withPolicyDefinitions(PolicyDefinition ... policyDefinitions) {
        this.policyDefinitions = Arrays.asList(policyDefinitions);
    }

    public FakeGatewayServer build() {
        List<MuleCoreExtension> coreExtensionInstances = this.coreExtensions.entrySet().stream().map(entry -> (MuleCoreExtension)((Supplier)entry.getValue()).get()).collect(Collectors.toList());
        FakeGatewayServer server = new FakeGatewayServer(this.muleHome, coreExtensionInstances, this.clusterId);
        this.policyTemplates.forEach(server::installPolicyTemplate);
        this.policyDefinitions.forEach(server::storePolicyDefinition);
        this.addServices(server);
        return server;
    }

    private void addServices(FakeGatewayServer server) {
        List infra = MavenInstallation.getDirectDependencies((String)GATEWAY_SERVICES, (String)GATEWAY_INFRASTRUCTURE, (String)MuleManifest.getProductVersion(), null, null);
        try {
            this.unzipService(server, this.artifact(infra, ORG_MULE_SERVICES, MULE_SERVICE_SCHEDULER));
            this.unzipService(server, this.artifact(infra, COM_MULESOFT_SERVICES, MULE_SERVICE_WEAVE));
            this.unzipService(server, this.artifact(infra, COM_MULESOFT_MULE_SERVICES, MULE_SERVICE_HTTP));
            this.unzipService(server, this.artifact(infra, GATEWAY_SERVICES, GATEWAY_SERVICE_CONTRACTS));
            this.unzipService(server, this.artifact(infra, GATEWAY_SERVICES, GATEWAY_SERVICE_EVENTS));
        }
        catch (IOException e) {
            throw new RuntimeException("Error adding services to Fake Gateway Server", e);
        }
    }

    private Artifact artifact(List<Dependency> dependencies, String groupId, String artifactId) {
        return dependencies.stream().filter(dependency -> this.dependencyMatches((Dependency)dependency, groupId, artifactId)).findFirst().orElseThrow(() -> new RuntimeException("Dependency " + artifactId + " not found in mule-services-all")).getArtifact();
    }

    private void unzipService(FakeGatewayServer server, Artifact artifact) throws IOException {
        File serviceFolder = new File(server.getServicesDir(), this.serviceFileName(artifact));
        FileUtils.unzip((File)MavenInstallation.resolveArtifact((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), (String)artifact.getClassifier(), (String)artifact.getExtension()), (File)serviceFolder);
    }

    private String serviceFileName(Artifact artifact) {
        return artifact.getArtifactId() + "-" + artifact.getVersion() + "-" + artifact.getClassifier();
    }

    private boolean dependencyMatches(Dependency dependency, String groupId, String artifactId) {
        return dependency.getArtifact().getArtifactId().equals(artifactId) && dependency.getArtifact().getGroupId().equals(groupId);
    }

    private MuleCoreExtension instanceCoreExtension(Class<? extends MuleCoreExtension> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<Class<? extends MuleCoreExtension>, Supplier<? extends MuleCoreExtension>> initialCoreExtensions() {
        HashMap<Class<? extends MuleCoreExtension>, Supplier<? extends MuleCoreExtension>> map = new HashMap<Class<? extends MuleCoreExtension>, Supplier<? extends MuleCoreExtension>>();
        map.put(HazelcastClusterCoreExtension.class, ClusterUtils::createClusterCoreExtension);
        map.put(ApiDeploymentCoreExtension.class, () -> {
            ApiDeploymentCoreExtension extension = (ApiDeploymentCoreExtension)this.instanceCoreExtension(ApiDeploymentCoreExtension.class);
            extension.setLockFactory((LockFactory)new ServerLockFactory());
            return extension;
        });
        return map;
    }
}

