/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionFactory;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionValidator;
import com.mulesoft.anypoint.discovery.core.version.MuleArtifactVersionFactory;
import com.mulesoft.anypoint.discovery.core.version.MuleArtifactVersionValidator;
import com.mulesoft.anypoint.tita.core.artifact.Jar;
import com.mulesoft.anypoint.tita.core.artifact.builder.ArtifactFileFactory;
import com.mulesoft.anypoint.tita.core.artifact.policy.Policy;
import com.mulesoft.anypoint.tita.core.maven.MavenInstallation;
import com.mulesoft.anypoint.tita.environment.api.artifact.PolicyArtifact;
import com.mulesoft.anypoint.tita.environment.api.artifact.PolicyJar;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;

public class ArtifactProvider {
    private static final String POLICY_CLASSIFIER = "mule-policy";
    private static final String TYPE = "jar";
    public static final MuleArtifactVersionFactory VERSION_FACTORY = new MuleArtifactVersionFactory();
    public static final MuleArtifactVersionValidator VERSION_VALIDATOR = new MuleArtifactVersionValidator();
    private static ArtifactFileFactory artifactFileFactory = new ArtifactFileFactory((ArtifactVersionFactory)VERSION_FACTORY, (ArtifactVersionValidator)VERSION_VALIDATOR);

    public static PolicyJar resolvePolicyTemplate(PolicyTemplateKey templateKey) {
        File jarFile = ArtifactProvider.policyJarFile(templateKey);
        return new PolicyJar(templateKey, jarFile, (ArtifactVersionFactory)VERSION_FACTORY);
    }

    public static PolicyArtifact buildPolicyTemplate(String id, PolicyTemplateKey templateKey, ApiKey apiKey, int order, Map<String, Object> configurationData) {
        return new Policy((PolicyDefinition)new OfflinePolicyDefinition(id, templateKey, apiKey, null, order, configurationData), new PolicyJar(templateKey, ArtifactProvider.policyJarFile(templateKey), (ArtifactVersionFactory)VERSION_FACTORY));
    }

    public static PolicyJar buildTestPolicyTemplate(PolicyTemplateKey templateKey, String templateConfig, String yamlSpec) {
        return ArtifactProvider.buildTestPolicyTemplate(templateKey, templateConfig, yamlSpec, new Dependency[0]);
    }

    public static PolicyJar buildTestPolicyTemplate(PolicyTemplateKey templateKey, String templateConfig) {
        return artifactFileFactory.createPolicyFile(templateKey, templateConfig, (List)Lists.newArrayList());
    }

    public static PolicyJar buildTestPolicyTemplate(PolicyTemplateKey templateKey, String templateConfig, String yamlSpec, Dependency ... dependencies) {
        PolicyJar jar = artifactFileFactory.createPolicyFile(templateKey, templateConfig, (List)Lists.newArrayList((Object[])dependencies));
        return new PolicyJar(templateKey, jar.getJarFile(), new File(ArtifactProvider.class.getResource(yamlSpec).getFile()), (ArtifactVersionFactory)VERSION_FACTORY);
    }

    public static PolicyJar buildTestPolicyTemplate(PolicyTemplateKey templateKey, String templateConfig, Dependency ... dependencies) {
        return artifactFileFactory.createPolicyFile(templateKey, templateConfig, (List)Lists.newArrayList((Object[])dependencies));
    }

    public static Jar buildTestApplication(String appName, String appConfig, Dependency ... dependencies) {
        return ArtifactProvider.buildTestApplication(appName, appConfig, (List<String>)Lists.newArrayList(), dependencies);
    }

    public static Jar buildTestApplication(String appName, String appConfig, Jar domainJar, Dependency ... dependencies) {
        return ArtifactProvider.buildTestApplication(appName, appConfig, (List<String>)Lists.newArrayList(), domainJar, dependencies);
    }

    public static Jar buildTestApplication(String appName, String appConfig, List<String> resources, Dependency ... dependencies) {
        return ArtifactProvider.buildTestApplication(appName, appConfig, resources, null, dependencies);
    }

    public static Jar buildTestApplication(String appName, String appConfig, List<String> resources, Jar domainJar, Dependency ... dependencies) {
        ArrayList dependenciesList = Lists.newArrayList((Object[])dependencies);
        return artifactFileFactory.createHeavyApp(appName, appConfig, resources, Collections.emptyList(), (List)dependenciesList, domainJar);
    }

    public static Jar buildTestDomain(String domainName, String domainConfig, Dependency ... dependencies) {
        ArrayList dependenciesList = Lists.newArrayList((Object[])dependencies);
        return artifactFileFactory.createDomain(domainName, domainConfig, Collections.emptyList(), (List)dependenciesList);
    }

    public static File policyJarFile(PolicyTemplateKey templateKey) {
        return MavenInstallation.resolveArtifact((String)templateKey.getGroupId(), (String)templateKey.getAssetId(), (String)templateKey.getVersion(), (String)POLICY_CLASSIFIER, (String)TYPE);
    }
}

