/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.rules;

import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.tck.junit4.rule.FreePortFinder;

public class ClusterDynamicPort
implements Disposable {
    private static final int DEFAULT_MIN_PORT = 10000;
    private static final int DEFAULT_MAX_PORT = 40000;
    private final FreePortFinder portFinder;
    private final String portName;
    private Map<FakeGatewayServer, Integer> serversAndPorts;

    public ClusterDynamicPort(String portName) {
        this(portName, 10000, 40000);
    }

    public ClusterDynamicPort(String portName, Integer minPortNumber, Integer maxPortNumber) {
        this.checkNotNull(portName, "Port name cannot be null");
        this.checkRange(minPortNumber, maxPortNumber);
        this.portName = portName;
        this.serversAndPorts = new HashMap<FakeGatewayServer, Integer>();
        this.portFinder = new FreePortFinder(minPortNumber.intValue(), maxPortNumber.intValue());
    }

    public Integer createPortForServer(FakeGatewayServer server) {
        this.checkNotAlreadyCreated(server);
        Integer newPort = this.portFinder.find();
        this.serversAndPorts.put(server, newPort);
        System.clearProperty(this.portName);
        System.setProperty(this.portName, Integer.toString(newPort));
        return newPort;
    }

    public Integer port(FakeGatewayServer server) {
        this.checkAlreadyCreated(server);
        return this.serversAndPorts.get((Object)server);
    }

    public void setPortForServer(FakeGatewayServer server) {
        System.clearProperty(this.portName);
        System.setProperty(this.portName, Integer.toString(this.port(server)));
    }

    public void dispose() {
        System.clearProperty(this.portName);
        for (FakeGatewayServer server : this.serversAndPorts.keySet()) {
            this.releasePort(server);
        }
        this.serversAndPorts.clear();
    }

    private void releasePort(FakeGatewayServer server) {
        int port = this.serversAndPorts.get((Object)server);
        this.portFinder.releasePort(port);
    }

    private void checkRange(Integer minPortNumber, Integer maxPortNumber) {
        if (minPortNumber > maxPortNumber) {
            throw new Error("Min and Max port do not create a valid range");
        }
    }

    private void checkNotNull(String variable, String onErrorMessage) {
        if (variable == null) {
            throw new Error(onErrorMessage);
        }
    }

    private void checkNotAlreadyCreated(FakeGatewayServer server) {
        if (this.serversAndPorts.containsKey((Object)server)) {
            throw new Error("Can only create one port for application: " + String.valueOf((Object)server));
        }
    }

    private void checkAlreadyCreated(FakeGatewayServer server) {
        if (!this.serversAndPorts.containsKey((Object)server)) {
            throw new Error("No port has been created for application: " + String.valueOf((Object)server));
        }
    }
}

