/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServerBuilder;
import com.mulesoft.anypoint.tests.infrastructure.installation.AbstractInstallationBuilder;
import com.mulesoft.anypoint.tests.infrastructure.installation.ClusterSystemProperties;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallationConfiguration;
import com.mulesoft.anypoint.tests.infrastructure.installation.Installation;
import com.mulesoft.anypoint.tests.infrastructure.rules.ClusterDynamicPort;
import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeGatewayClusterInstallation
extends ExternalResource
implements Installation<FakeGatewayClusterInstallation> {
    private static final int DEFAULT_NODES = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeGatewayClusterInstallation.class);
    private List<FakeGatewayServer> servers = new ArrayList<FakeGatewayServer>();
    private List<Artifact> applications = new ArrayList<Artifact>();
    private ClusterDynamicPort dynamicPort;
    private ClusterSystemProperties clusterSystemProperties;
    private FakeGatewayInstallationConfiguration configuration;
    private boolean clientMode;
    private int numberOfGroups = 1;
    private Builder builder;

    public FakeGatewayClusterInstallation(List<Artifact> applications, ClusterDynamicPort dynamicPort, FakeGatewayInstallationConfiguration configuration, boolean clientMode, int numberOfGroups, Builder builder) {
        this.updateState(this.servers, applications, dynamicPort, configuration, clientMode, numberOfGroups, builder);
    }

    public static Builder builder() {
        return new Builder(2, 1);
    }

    public static Builder withSize(int size) {
        return new Builder(size, 1);
    }

    public static Builder builder(int numberOfGroups) {
        return new Builder(2, numberOfGroups);
    }

    protected void before() throws Throwable {
        this.servers = this.builder.buildServers();
        this.configuration.before();
        try {
            this.spinUpServers();
        }
        catch (Throwable t) {
            this.after();
            throw t;
        }
    }

    protected void after() {
        this.configuration.after();
        this.clusterSystemProperties.after();
        this.dynamicPort.dispose();
        this.servers.forEach(server -> {
            this.stopQuietly((FakeGatewayServer)((Object)server));
            FileUtils.deleteQuietly((File)server.getMuleHome());
        });
    }

    @Override
    public FakeGatewayClusterInstallation restart() {
        try {
            for (FakeGatewayServer server : this.servers) {
                this.stopQuietly(server);
            }
            this.dynamicPort.dispose();
            this.replicate(this.builder.build());
            this.servers = this.builder.buildServers();
            this.spinUpServers();
        }
        catch (Exception error) {
            error.printStackTrace();
            Assert.fail((String)this.restartMessage(error));
        }
        return this;
    }

    public FakeGatewayServer getNode(int i) {
        return this.servers.get(i);
    }

    private void startClusterNodes(int nodeIdSeed, List<FakeGatewayServer> servers) throws Exception {
        int i = nodeIdSeed;
        for (FakeGatewayServer server : servers) {
            System.setProperty("mule.clusterId", server.getClusterId());
            this.startNode(server, i++);
        }
    }

    private void startNode(FakeGatewayServer server, int nodeId) throws IOException, MuleException {
        System.setProperty("mule.home", server.getMuleHome().getAbsolutePath());
        this.clusterSystemProperties.updateClusterNodeIdProperty(String.valueOf(nodeId));
        if (this.dynamicPort != null) {
            this.dynamicPort.createPortForServer(server);
        }
        server.installApplications(this.applications);
        server.start();
        this.applications.forEach(app -> server.assertDeploymentSuccess(app.getName()));
    }

    private void stopQuietly(FakeGatewayServer server) {
        try {
            server.stop();
        }
        catch (Throwable e) {
            LOGGER.error("Stop failed, reason: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FakeGatewayClusterInstallation whileNodeIsStopped(int ithNode, Runnable closure) {
        try {
            this.stopQuietly(this.getNode(ithNode));
            closure.run();
        }
        catch (Exception e) {
            Assert.fail((String)("Closure execution failed: " + this.temporalStopMessage(e)));
        }
        finally {
            this.restart();
        }
        return this;
    }

    @Override
    public FakeGatewayClusterInstallation removePoliciesAndContext() {
        this.servers.forEach(FakeGatewayServer::removeAllPoliciesAndContext);
        return this;
    }

    private void spinUpServers() throws Exception {
        this.spinUpServers(1, this.servers);
    }

    private void spinUpServers(int nodeIdSeed, List<FakeGatewayServer> servers) throws Exception {
        this.clusterSystemProperties.before();
        this.startClusterNodes(nodeIdSeed, servers);
        this.assertClusterStarted();
    }

    private void replicate(FakeGatewayClusterInstallation newInstallation) {
        this.updateState(newInstallation.servers, newInstallation.applications, newInstallation.dynamicPort, newInstallation.configuration, newInstallation.clientMode, newInstallation.numberOfGroups, newInstallation.builder);
    }

    private void updateState(List<FakeGatewayServer> servers, List<Artifact> applications, ClusterDynamicPort dynamicPort, FakeGatewayInstallationConfiguration configuration, boolean clientMode, int numberOfGroups, Builder builder) {
        this.servers = servers;
        this.dynamicPort = dynamicPort;
        this.applications = applications;
        this.clientMode = clientMode;
        this.configuration = configuration;
        this.clusterSystemProperties = new ClusterSystemProperties(servers.size(), clientMode);
        this.numberOfGroups = numberOfGroups;
        this.builder = builder;
    }

    private String temporalStopMessage(Exception onError) {
        return "Failed to temporarily stop a server in Cluster Installation, reason: " + onError.getMessage();
    }

    private String restartMessage(Throwable onError) {
        return "Failed to restart servers in Cluster Installation, reason: " + onError.getMessage();
    }

    private void assertClusterStarted() {
        new PollingProber().check(new Probe(){

            public boolean isSatisfied() {
                if (!FakeGatewayClusterInstallation.this.clientMode) {
                    ClusterCoreExtension clusterCodeExtension = FakeGatewayClusterInstallation.this.servers.get(0).getCoreExtension(ClusterCoreExtension.class);
                    ClusterManager clusterManager = clusterCodeExtension.getClusterManager();
                    return clusterManager.size() == FakeGatewayClusterInstallation.this.servers.size();
                }
                return true;
            }

            public String describeFailure() {
                return "cluster was not created successfully";
            }
        });
    }

    public static class Builder
    extends AbstractInstallationBuilder<Builder> {
        Builder(int size, int numberOfGroups) {
            super(size, numberOfGroups);
        }

        @Override
        public FakeGatewayClusterInstallation build() {
            FakeGatewayInstallationConfiguration configuration = new FakeGatewayInstallationConfiguration(this.gatewayMode, false, null, this.gateKeeperMode, this.jdbcStoreConfiguration, this.onApiDeleted);
            configuration.before();
            return new FakeGatewayClusterInstallation(this.applications, this.dynamicPort, configuration, this.clientModeEnabled, 1, this);
        }

        private List<FakeGatewayServer> buildServers() {
            return this.serverBuilders.stream().map(FakeGatewayServerBuilder::build).collect(Collectors.toList());
        }
    }
}

