/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.tests.metrics;

import static com.google.common.collect.ImmutableMap.of;
import static com.mulesoft.anypoint.tests.metrics.GatewayVersionFilter.TITA_TESTING_VALUE;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.tck.probe.PollingProber;

import com.mulesoft.anypoint.tests.DescriptiveProbe;
import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.http.HttpResponse;
import com.mulesoft.anypoint.tita.environment.api.anypoint.ApiManager;
import com.mulesoft.anypoint.tita.environment.api.anypoint.Metrics;
import com.mulesoft.anypoint.tita.environment.api.artifact.policy.PolicySupplier;
import com.mulesoft.anypoint.tita.environment.api.runtime.Runtime;
import com.mulesoft.anypoint.tita.environment.api.artifact.PolicyArtifact;
import com.mulesoft.anypoint.tita.runner.ambar.Ambar;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.Platform;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.Policy;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.TestTarget;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.runtime.Property;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.runtime.Standalone;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(Ambar.class)
public class MetricsTestCase {

  private static final String POLICY_PAYLOAD = "PolicyApplied Offline!";

  @Standalone(testing = TITA_TESTING_VALUE, properties = {
      // AGW-4950: Probably add this as part of configuration instead of sending the property here?
      @Property(key = "anypoint.platform.metrics_push_freq", value = "1")
  })
  private Runtime runtime;

  private HttpRequest request;

  @TestTarget
  @Policy(groupId = "com.mulesoft.anypoint.tita.policy", artifactId = "set-payload-policy")
  private PolicySupplier policySupplier;

  private PolicyArtifact policy;

  @Platform(run = "local")
  private ApiManager apiManager;

  @Platform(run = "local")
  private Metrics metrics;

  @Before
  public void setUpTest() {
    policy = policySupplier.create(runtime.api().key(), 1, of("text", "Offline"));
    request = runtime.api().request();
  }

  @Test
  public void offlinePolicyIsAppliedOnMuleStart() {
    PolicyArtifact artifact = apiManager.apply(policySupplier, 1, of("text", "Offline"));
    assertThat(request.get().asString(), is(POLICY_PAYLOAD));

    apiManager.unapply(artifact);

    new PollingProber(10000, 500).check(new DescriptiveProbe(() -> {
      // This number includes the Gateway start event. Probably we should test is separately.
      assertThat(metrics.eventCount(), is(3));
    }, "Some metrics events were not sent"));
  }
}
