/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.offline;

import static com.google.common.collect.ImmutableMap.of;
import static com.mulesoft.anypoint.test.policy.GatewayVersionFilter.TITA_TESTING_VALUE;
import static com.mulesoft.anypoint.tita.environment.api.artifact.Identifier.identifier;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.isEmptyString;

import org.mule.tck.junit4.AbstractMuleTestCase;

import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tita.environment.api.ApplicationSelector;
import com.mulesoft.anypoint.tita.environment.api.artifact.ApplicationBuilder;
import com.mulesoft.anypoint.tita.environment.api.artifact.Identifier;
import com.mulesoft.anypoint.tita.environment.api.artifact.PolicyArtifact;
import com.mulesoft.anypoint.tita.environment.api.artifact.policy.PolicySupplier;
import com.mulesoft.anypoint.tita.environment.api.runtime.Runtime;
import com.mulesoft.anypoint.tita.runner.ambar.Ambar;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.Application;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.Policy;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.TestTarget;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.runtime.Standalone;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(Ambar.class)
public class OfflinePolicyTestCase extends AbstractMuleTestCase {

  private static final String POLICY_PAYLOAD = "PolicyApplied Offline!";
  private static Identifier api = identifier("apiId");
  private static Identifier port = identifier("port");

  @Standalone(testing = TITA_TESTING_VALUE)
  private Runtime runtime;

  @Application
  public static ApplicationBuilder app(ApplicationSelector selector) {
    return selector
        .custom("customAppOffline", "mule-config-single-api.xml")
        .withApi(api, port);
  }

  private HttpRequest request;

  @TestTarget
  @Policy(groupId = "com.mulesoft.anypoint.tita.policy", artifactId = "set-payload-policy")
  private PolicySupplier policySupplier;

  private PolicyArtifact policy;

  @Before
  public void setUpTest() {
    policy = policySupplier.create(runtime.api(api).key(), 1, of("text", "Offline"));
    request = runtime.api(api).request("/api/main");
  }


  @Test
  public void offlinePolicyIsAppliedOnMuleStart() {
    runtime.deployOffline(policy);
    assertThat(request.get().asString(), is(POLICY_PAYLOAD));

    runtime.restart();

    assertThat(request.get().asString(), is(POLICY_PAYLOAD));
  }

  @Test
  public void removeOfflinePolicyAfterIsAppliedOnMuleStart() {
    runtime.deployOffline(policy);
    assertThat(request.get().asString(), is(POLICY_PAYLOAD));

    runtime.restart();

    assertThat(request.get().asString(), is(POLICY_PAYLOAD));

    runtime.undeployOffline(policy);

    assertThat(request.get().asString(), isEmptyString());
  }

}
