/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy;

import static java.lang.System.getProperty;
import static java.util.stream.Collectors.toList;

import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionFactory;
import com.mulesoft.anypoint.tita.environment.api.configuration.filter.VersionsFilter;

import java.util.Comparator;
import java.util.List;

public class GatewayVersionFilter implements VersionsFilter {

  public static final String TITA_TESTING_VALUE = "custom:com.mulesoft.anypoint.test.policy.GatewayVersionFilter";

  public static final String TITA_TESTING_VERSION = "titaTestingVersion";
  private final String version;

  public GatewayVersionFilter(ArtifactVersionFactory versionFactory, Comparator<ArtifactVersion> versionComparator) {
    this.version = getProperty(TITA_TESTING_VERSION);
  }

  @Override
  public List<ArtifactVersion> filter(List<ArtifactVersion> versionsToFilter) {
    return versionsToFilter.stream().filter(ver -> ver.value().equals(this.version)).collect(toList());
  }
}
