/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.zero.downtime;

import static com.mulesoft.anypoint.test.policy.GatewayVersionFilter.TITA_TESTING_VALUE;
import static com.mulesoft.anypoint.tita.environment.api.Tita.performanceMatchers;
import static com.mulesoft.anypoint.tita.environment.api.artifact.Identifier.identifier;
import static java.util.Collections.singletonList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.PollingProber;

import com.mulesoft.anypoint.tests.DescriptiveProbe;
import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tita.environment.api.ApplicationSelector;
import com.mulesoft.anypoint.tita.environment.api.anypoint.ApiManager;
import com.mulesoft.anypoint.tita.environment.api.artifact.ApplicationBuilder;
import com.mulesoft.anypoint.tita.environment.api.artifact.Identifier;
import com.mulesoft.anypoint.tita.environment.api.artifact.PolicyArtifact;
import com.mulesoft.anypoint.tita.environment.api.artifact.policy.PolicySupplier;
import com.mulesoft.anypoint.tita.environment.api.performance.PerformanceEngine;
import com.mulesoft.anypoint.tita.environment.api.performance.PerformanceResult;
import com.mulesoft.anypoint.tita.environment.api.performance.StatusCode;
import com.mulesoft.anypoint.tita.environment.api.runtime.Runtime;
import com.mulesoft.anypoint.tita.environment.api.runtime.builder.RuntimeConfiguration;
import com.mulesoft.anypoint.tita.runner.ambar.Ambar;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.Application;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.Performance;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.Platform;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.Policy;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.TestTarget;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.runtime.Property;
import com.mulesoft.anypoint.tita.runner.ambar.annotation.runtime.Standalone;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(Ambar.class)
public class TransactionalEditionTestCase extends AbstractMuleTestCase {

  protected static Identifier api = identifier("apiId");
  protected static Identifier port = identifier("port");

  @Standalone(testing = TITA_TESTING_VALUE, properties = {@Property(key = "throttling.persistence_enabled", value = "false")})
  protected Runtime runtime;

  @Platform
  protected ApiManager apiManager;

  @Application
  public static ApplicationBuilder app(ApplicationSelector selector) {
    return selector
        .custom("customAppZeroDowntime", "zeroDowntime.xml")
        .withApi(api, port);
  }

  @TestTarget
  @Policy(artifactId = "rate-limiting")
  private PolicySupplier policy;

  @Policy(artifactId = "config-failure-policy")
  private PolicySupplier payloadPolicy;

  @Test
  public void successfulEdit() {

    PolicyArtifact artifact = apiManager.apply(api, payloadPolicy, 1, failureConfig(false, "#['config1']"));

    assertThat(request().get().asString(), is("config1"));

    apiManager.edit(artifact, 3, failureConfig(false, "#['config2']"));

    assertThat(request().get().asString(), is("config2"));
  }

  @Test
  public void failureToEditRevertsToPreviousValidState() {

    PolicyArtifact artifact = apiManager.apply(api, payloadPolicy, 1, failureConfig(false, "#['config1']"));

    assertThat(request().get().asString(), is("config1"));

    PolicyArtifact editArtifact = apiManager.async().edit(artifact, 2, failureConfig(true, "#['config2']"));

    runtime.state().waitForFailure(editArtifact);
    runtime.state().waitFor(artifact);

    assertThat(request().get().asString(), is("config1"));

    PolicyArtifact editArtifact2 = apiManager.async().edit(artifact, 3, failureConfig(true, "#['config3']"));

    runtime.state().waitForFailure(editArtifact2);
    runtime.state().waitFor(artifact);

    assertThat(request().get().asString(), is("config1"));
  }

  @Test
  public void revertPreservedOnRestart() {

    PolicyArtifact artifact = apiManager.apply(api, payloadPolicy, 1, failureConfig(false, "#['config1']"));

    assertThat(request().get().asString(), is("config1"));

    PolicyArtifact editArtifact = apiManager.async().edit(artifact, 2, failureConfig(true, "#['config2']"));

    runtime.state().waitForFailure(editArtifact);
    runtime.state().waitFor(artifact);

    runtime.restart(RuntimeConfiguration.builder().gateKeeperDisabled().offline().build());

    assertThat(request().get().asString(), is("config1"));
  }

  protected HttpRequest request() {
    return runtime.api(api).request("api/main/200");
  }

  protected Map<String, Object> failureConfig(Boolean fail, String payload) {
    Map<String, Object> configData = new HashMap<>();
    configData.put("text", payload);
    configData.put("fail", fail.toString());

    return configData;
  }
}
