/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.deployment;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static java.util.Collections.emptyMap;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.http.SimpleHttpServerResponse;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.rules.HttpServerRule;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import org.junit.Before;

public abstract class ExternalServerConnectionTestCase extends AbstractMuleTestCase {

  protected static final ApiKey EMPTY_API_KEY = new ApiKey(1L);
  protected static final String EXTERNAL_SERVER_PAYLOAD = "ExternalServerPayload";
  protected static final String REQUEST_PAYLOAD = "-payload first request-";

  protected static DynamicPort port = new DynamicPort("port");

  protected static HttpServerRule externalServer = new HttpServerRule("externalServerPort");

  @Before
  public void setUp() {
    externalServer.getHttpServer().setResponse(SimpleHttpServerResponse.builder().body(EXTERNAL_SERVER_PAYLOAD).build());
  }

  protected PolicyDefinition policyDefinition(PolicyTemplateKey templateKey, ApiKey apiKey) {
    return new PolicyDefinition(POLICY_ID, templateKey, apiKey, null, 1, new PolicyConfiguration(emptyMap()));
  }

  protected HttpRequest emptyRequest() {
    return request(port, "/api/empty");
  }

  protected HttpRequest appendPayloadRequest() {
    return request(port, "/api/append-payload");
  }

  protected HttpRequest proxyRequest() {
    return request(port, "/api/proxy");
  }

}
