/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.deployment;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD_2;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.getPoliciesFolder;
import static java.util.Collections.emptyMap;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStoreFiles;


public abstract class PolicyDeploymentTestCase extends AbstractMuleTestCase {

  protected static final ApiKey EMPTY_API_KEY = new ApiKey(1L);
  protected static final ApiKey SET_PAYLOAD_API_KEY = new ApiKey(2L);

  protected static final PolicyTemplateKey INVALID_XML_TEMPLATE_ID =
      new PolicyTemplateKey("com.mulesoft.anypoint", "invalidXML", "0.1.0");
  protected static final PolicyTemplateKey EMPTY_TEMPLATE_ID =
      new PolicyTemplateKey("com.mulesoft.anypoint", "empty", "0.1.0");
  protected static final PolicyTemplateKey WITHOUT_EXECUTE_NEXT_TEMPLATE_ID =
      new PolicyTemplateKey("com.mulesoft.anypoint", "withoutExecuteNext", "0.1.0");
  protected static final PolicyTemplateKey MULTIPLE_EXECUTE_NEXT_TEMPLATE_ID =
      new PolicyTemplateKey("com.mulesoft.anypoint", "multipleExecuteNext", "0.1.0");
  protected static final PolicyTemplateKey INVALID_AT_INIT_TEMPLATE_ID =
      new PolicyTemplateKey("com.mulesoft.anypoint", "invalidAtInit", "0.1.0");
  protected static final PolicyTemplateKey API_INJECTION_TEMPLATE_ID =
      new PolicyTemplateKey("com.mulesoft.anypoint", "apiInjection", "0.1.0");
  protected static final PolicyTemplateKey WRONG_HTTP_VERSION =
      new PolicyTemplateKey("com.mulesoft.anypoint", "apiInjection", "0.1.0");

  protected static DynamicPort httpPort = new DynamicPort("port");
  protected static SystemProperty policyPayload = new SystemProperty("policyPayload", POLICY_PAYLOAD);
  protected static SystemProperty policyPayload2 = new SystemProperty("policyPayload2", POLICY_PAYLOAD_2);

  protected HttpRequest request = request(httpPort, "/api/empty");

  protected PolicyStore policyStore = new DefaultPolicyStore(new EncryptedPropertiesSerializer());
  protected PolicyStoreFiles storeFiles = new PolicyStoreFiles(getPoliciesFolder());

  protected PolicyDefinition policyDefinition(PolicyTemplateKey templateKey) {
    return new PolicyDefinition(POLICY_ID, templateKey, EMPTY_API_KEY, null, 1, new PolicyConfiguration(emptyMap()));
  }

}
