/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.deployment;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.TestDependencies.objectStoreExtensionDependency;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static java.util.Collections.singletonMap;
import static org.junit.Assert.assertEquals;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import io.qameta.allure.Issue;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;


public class PolicyUpgradeTestCase extends AbstractMuleTestCase {

  private static final ApiKey EMPTY_API_KEY = new ApiKey(1L);

  private static final PolicyTemplateKey POLICY_TEMPLATE_KEY =
      new PolicyTemplateKey("com.mulesoft.anypoint", "policyTemplate", "1.0.0");
  private static final PolicyTemplateKey UPGRADED_POLICY_TEMPLATE_KEY =
      new PolicyTemplateKey("com.mulesoft.anypoint", "policyTemplate", "1.0.1");

  private static DynamicPort httpPort = new DynamicPort("port");

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(buildTestApplication(APP, "mule-config-http.xml"))
          .withPolicyTemplates(buildTestPolicyTemplate(POLICY_TEMPLATE_KEY,
                                                       "policies/policy-deployment-object-store-policy.xml",
                                                       objectStoreExtensionDependency()),
                               buildTestPolicyTemplate(UPGRADED_POLICY_TEMPLATE_KEY,
                                                       "policies/policy-deployment-object-store-policy.xml",
                                                       objectStoreExtensionDependency()))
          .gateKeeperDisabled()
          .offline()
          .build();

  @ClassRule
  public static RuleChain chain = RuleChain.outerRule(httpPort)
      .around(installation);

  private HttpRequest request = request(httpPort, "/api/empty");
  private FakeGatewayServer server = installation.getServer();

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }

  @Test
  @Issue("AGW-4287")
  public void policyUpgradeOfPolicyUsingSerialization() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY);

    server.deployPolicy(policyDefinition);

    assertEquals("Policy not correctly applied", POLICY_PAYLOAD, request.get().asString());

    PolicyDefinition policyDefinition2 = policyDefinition(POLICY_ID_2, UPGRADED_POLICY_TEMPLATE_KEY);
    server.deployPolicy(policyDefinition2);
    server.undeployPolicy(policyDefinition.getName());

    assertEquals("Policy not correctly applied", POLICY_PAYLOAD, request.get().asString());
  }

  private PolicyDefinition policyDefinition(String policyId, PolicyTemplateKey templateKey) {
    return new PolicyDefinition(policyId, templateKey, EMPTY_API_KEY, null, 1,
                                new PolicyConfiguration(singletonMap("policyPayload", POLICY_PAYLOAD)));
  }

}
