/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.deployment;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static java.util.Collections.emptyMap;
import static java.util.concurrent.TimeUnit.SECONDS;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import java.util.UUID;
import java.util.concurrent.CountDownLatch;

import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

/**
 * Test added to make sure that when there are multiple messages with the same Correlation Id being processed in the runtime,
 * policies still are working as expected (SE-8736)
 */
public class PolicyWithCorrelationIdTestCase extends AbstractMuleTestCase {

  private static DynamicPort httpPort = new DynamicPort("port");
  private static SystemProperty policyPayload = new SystemProperty("policyPayload", POLICY_PAYLOAD);

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(buildTestApplication(APP, "mule-config-with-wait.xml"))
          .withPolicyTemplates(buildTestPolicyTemplate(POLICY_TEMPLATE_KEY, "policies/policy-deployment-policy.xml"))
          .gateKeeperDisabled()
          .offline()
          .build();

  @ClassRule
  public static RuleChain chain = RuleChain.outerRule(httpPort)
      .around(policyPayload)
      .around(installation);

  private FakeGatewayServer server = installation.getServer();

  private HttpRequest request = request(httpPort, "/api/wait");

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }

  @Test
  public void deploySinglePolicy() throws InterruptedException {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY);

    server.deployPolicy(policyDefinition);
    CountDownLatch latch = new CountDownLatch(2);

    assertEquals(POLICY_PAYLOAD, request.withHeader("X-Correlation-ID", UUID.randomUUID().toString()).get().asString());

    Thread thread = new Thread(doRequest(latch));
    Thread second = new Thread(doRequest(latch));

    thread.start();

    Thread.sleep(1000);

    second.start();

    assertThat(latch.await(10, SECONDS), is(true));
  }

  private PolicyDefinition policyDefinition(PolicyTemplateKey templateKey) {
    return new PolicyDefinition(POLICY_ID, templateKey, API_KEY, null, 1, new PolicyConfiguration(emptyMap()));
  }

  private Runnable doRequest(CountDownLatch latch) {
    return () -> {
      assertEquals(POLICY_PAYLOAD, request.get().asString());
      latch.countDown();
    };
  }

}
