/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.deployment;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static java.util.Collections.emptyList;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertThat;

import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import org.apache.maven.model.Dependency;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class PolicyWithLaterHttpVersionTestCase extends PolicyDeploymentTestCase {

  private static final String LATER_HTTP_CONNECTOR_VERSION = "1.5.6";
  private static final String EARLIER_HTTP_CONNECTOR_VERSION = "1.5.3";

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(
                            buildTestApplication(APP, "mule-config-http.xml", emptyList(),
                                                 httpConnector(EARLIER_HTTP_CONNECTOR_VERSION)))
          .withPolicyTemplates(buildTestPolicyTemplate(WRONG_HTTP_VERSION, "policies/policy-deployment-api-injection.xml",
                                                       httpConnector(LATER_HTTP_CONNECTOR_VERSION)))
          .gateKeeperDisabled()
          .offline()
          .build();

  private FakeGatewayServer server = installation.getServer();

  @ClassRule
  public static RuleChain chain = RuleChain.outerRule(httpPort)
      .around(installation);

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }

  @Test
  public void deployPolicyWithLaterHttpVersionThanApp() {
    PolicyDefinition policyDefinition = policyDefinition(WRONG_HTTP_VERSION);

    server.deployPolicy(policyDefinition);

    assertNotEquals("Policy shouldn't be applied.", POLICY_PAYLOAD, request.get().asString());
    assertThat(storeFiles.listPolicyDeploymentFailures(), hasSize(1));
    assertThat(policyStore.load(), hasSize(1));
    assertThat(policyStore.load().get(0), is(policyDefinition));
  }

  private static Dependency httpConnector(String version) {
    Dependency dependency = new Dependency();

    dependency.setGroupId("org.mule.connectors");
    dependency.setArtifactId("mule-http-connector");
    dependency.setVersion(version);
    dependency.setClassifier("mule-plugin");

    return dependency;
  }
}
