/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.deployment;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_3;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.TestDependencies.testAssertionsDependency;
import static com.mulesoft.anypoint.tita.TestDependencies.testAuthenticationDependency;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactFileFactory.HTTP_DEPENDENCY;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static java.nio.charset.StandardCharsets.UTF_8;
import static java.util.stream.IntStream.range;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import org.mule.functional.util.http.HttpMessage;
import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.anypoint.tests.http.HttpResponse;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class PolicyWithOperationRequesterTestCase extends ExternalServerConnectionTestCase {

  private static final String BACKEND_PAYLOAD = "PAYLOAD NO API BACKEND";
  protected static DynamicPort httpPort = new DynamicPort("httpPort");

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(buildTestApplication(APP, "mule-config-http-with-proxy.xml", testAssertionsDependency(),
                                                 testAuthenticationDependency()),
                            buildTestApplication("backend-app", "no-api-backend.xml"))
          .withPolicyTemplates(buildTestPolicyTemplate(POLICY_TEMPLATE_KEY_2, "policies/policy-with-operation-requester.xml",
                                                       HTTP_DEPENDENCY),
                               buildTestPolicyTemplate(POLICY_TEMPLATE_KEY_3,
                                                       "policies/policy-operation-with-requester-url-config-on-before.xml",
                                                       HTTP_DEPENDENCY),
                               buildTestPolicyTemplate(POLICY_TEMPLATE_KEY,
                                                       "policies/policy-operation-with-requester-url-config-on-after.xml",
                                                       HTTP_DEPENDENCY))
          .gateKeeperDisabled()
          .offline()
          .build();

  @ClassRule
  public static RuleChain ruleChain = RuleChain.outerRule(port)
      .around(httpPort)
      .around(externalServer)
      .around(installation);

  private FakeGatewayServer server = installation.getServer();

  @Test
  public void operationRequester() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY_2, EMPTY_API_KEY);

    server.deployPolicy(policyDefinition);
    range(0, 10).forEach(i -> {
      HttpResponse response = emptyRequest().get();
      assertThat(response.statusCode(), is(200));
      assertThat(response.asString(), is("hey this is crazy PAYLOAD NO API BACKEND " + EXTERNAL_SERVER_PAYLOAD));
    });
  }

  @Test
  public void policyWithRequesterUrlBeforeExecuteNext() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY_3, EMPTY_API_KEY);

    server.deployPolicy(policyDefinition);

    HttpResponse response = emptyRequest().withPayload(REQUEST_PAYLOAD).post();
    HttpMessage externalServerRequest = externalServer.getHttpServer().getLastHttpRequest();
    assertThat(response.statusCode(), is(200));
    assertThat(response.asString(),
               is("PolicyHasBeenApplied: " + REQUEST_PAYLOAD + " " + EXTERNAL_SERVER_PAYLOAD + BACKEND_PAYLOAD));
    assertThat(new String(externalServerRequest.getBody(), UTF_8), is(REQUEST_PAYLOAD));
  }

  @Test
  public void policyWithRequesterUrlAfterExecuteNext() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY, EMPTY_API_KEY);

    server.deployPolicy(policyDefinition);

    HttpResponse response = emptyRequest().withPayload(REQUEST_PAYLOAD).post();
    assertThat(response.statusCode(), is(200));
    assertThat(response.asString(),
               is("PolicyHasBeenApplied: " + REQUEST_PAYLOAD + BACKEND_PAYLOAD + " " + EXTERNAL_SERVER_PAYLOAD));
  }

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }
}
