/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.deployment;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_3;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactFileFactory.HTTP_DEPENDENCY;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static java.nio.charset.StandardCharsets.UTF_8;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import org.mule.functional.util.http.HttpMessage;

import com.mulesoft.anypoint.tests.http.HttpResponse;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import io.qameta.allure.Issue;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class PolicyWithSourceRequesterTestCase extends ExternalServerConnectionTestCase {

  private static final PolicyTemplateKey POLICY_TEMPLATE_KEY_4 =
      new PolicyTemplateKey("com.mulesoft.anypoint", "policyTemplate-4", "0.1.0");
  private static final PolicyTemplateKey POLICY_TEMPLATE_KEY_5 =
      new PolicyTemplateKey("com.mulesoft.anypoint", "policyTemplate-5", "0.1.0");

  private static final ApiKey APPEND_PAYLOAD_API_KEY = new ApiKey(3L);
  private static final ApiKey PROXY_API_KEY = new ApiKey(9L);

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(buildTestApplication(APP, "mule-config-http.xml"))
          .withPolicyTemplates(buildTestPolicyTemplate(POLICY_TEMPLATE_KEY, "policies/policy-with-requester.xml",
                                                       HTTP_DEPENDENCY),
                               buildTestPolicyTemplate(POLICY_TEMPLATE_KEY_3,
                                                       "policies/policy-with-requester-url-config-on-before.xml",
                                                       HTTP_DEPENDENCY),
                               buildTestPolicyTemplate(POLICY_TEMPLATE_KEY_2,
                                                       "policies/policy-with-requester-url-config-on-after.xml",
                                                       HTTP_DEPENDENCY),
                               buildTestPolicyTemplate(POLICY_TEMPLATE_KEY_4,
                                                       "policies/policy-without-operation.xml"),
                               buildTestPolicyTemplate(POLICY_TEMPLATE_KEY_5,
                                                       "policies/policy-with-operation.xml", HTTP_DEPENDENCY))
          .gateKeeperDisabled()
          .offline()
          .build();

  @ClassRule
  public static RuleChain ruleChain = RuleChain.outerRule(port)
      .around(externalServer)
      .around(installation);

  private FakeGatewayServer server = installation.getServer();

  @Test
  public void sourceRequester() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY, EMPTY_API_KEY);

    server.deployPolicy(policyDefinition);

    assertThat(emptyRequest().get().asString(), is(EXTERNAL_SERVER_PAYLOAD));
  }

  @Test
  public void policyWithRequesterUrlBeforeExecuteNext() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY_3, APPEND_PAYLOAD_API_KEY);

    server.deployPolicy(policyDefinition);

    HttpResponse response = appendPayloadRequest().withPayload(REQUEST_PAYLOAD).post();
    assertThat(response.statusCode(), is(200));
    assertThat(response.asString(),
               is("PolicyHasBeenApplied: " + REQUEST_PAYLOAD + " " + EXTERNAL_SERVER_PAYLOAD + "Flow Payload"));
    HttpMessage externalServerRequest = externalServer.getHttpServer().getLastHttpRequest();
    assertThat(new String(externalServerRequest.getBody(), UTF_8), is(REQUEST_PAYLOAD));
  }

  @Test
  public void policyWithRequesterUrlAfterExecuteNext() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY_2, EMPTY_API_KEY);

    server.deployPolicy(policyDefinition);

    HttpResponse response = emptyRequest().withPayload(REQUEST_PAYLOAD).post();
    assertThat(response.statusCode(), is(200));
    assertThat(response.asString(),
               is("PolicyHasBeenApplied: " + REQUEST_PAYLOAD + " " + EXTERNAL_SERVER_PAYLOAD));
  }

  @Test
  @Issue(value = "MULE-18433")
  public void policyWithRequesterAfterOperationPolicy() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY_4, PROXY_API_KEY);
    PolicyDefinition policyDefinition2 = policyDefinition(POLICY_TEMPLATE_KEY_5, PROXY_API_KEY);

    server.deployPolicy(policyDefinition);
    server.deployPolicy(policyDefinition2);

    assertThat(proxyRequest().get().asString(),
               is("policy1Before-policy2Before-backend-flow-policy2After-policy1After"));
  }

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }
}
