/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.deployment;

import static com.google.common.collect.Lists.newArrayList;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactFileFactory.HTTP_DEPENDENCY;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static java.util.Collections.emptyMap;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import org.apache.maven.model.Dependency;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class ResourceLevelPolicyIgnoreBasePathOldHtttpDeploymentTestCase extends AbstractMuleTestCase {

  private static DynamicPort portApp1 = new DynamicPort("port");

  private static SystemProperty policyPayload = new SystemProperty("policyPayload", POLICY_PAYLOAD);

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(buildTestApplication(APP, "mule-config-ignore-base-path-annotation.xml",
                                                 oldHttpDependency()))
          .withPolicyTemplates(buildTestPolicyTemplate(POLICY_TEMPLATE_KEY, "policies/policy-deployment-policy.xml"))
          .gateKeeperDisabled()
          .offline()
          .build();

  private static Dependency oldHttpDependency() {
    Dependency dependency = HTTP_DEPENDENCY;
    dependency.setVersion("1.5.3");
    return dependency;
  }

  @ClassRule
  public static RuleChain ruleChain = RuleChain.outerRule(portApp1)
      .around(policyPayload)
      .around(installation);

  private HttpRequest enabledRequest = request(portApp1, "/base/path/enabled/api/resource");;

  private FakeGatewayServer server = installation.getServer();

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }

  @Test
  public void ignoreBasePathWithOlderHttpWorksAsBeforeEvenWhenEnabled() {
    HttpResourcePointcut pointcut = new HttpResourcePointcut("/base/path/enabled/api/.*", ".*");
    PolicyDefinition policyDefinition = policyDefinition(new ApiKey(1L), pointcut);

    server.deployPolicy(policyDefinition);

    assertThat(enabledRequest.get().asString(), is(POLICY_PAYLOAD));
  }

  private PolicyDefinition policyDefinition(ApiKey apiKey, HttpResourcePointcut resourcePointcut) {
    return new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, apiKey, newArrayList(resourcePointcut), 1,
                                new PolicyConfiguration(emptyMap()));
  }

}
