/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error;

import java.util.HashMap;
import java.util.Map;

public class Config {

  private Map<String, Object> config = new HashMap<>();

  public Config(String policyId, boolean propagateMessageTransformations) {
    config.put("policyId", policyId);
    config.put("propagationEnabled", propagateMessageTransformations);
  }

  /**
   * Makes the policy to define an on-error-continue handler.
   */
  public Config errorContinue() {
    config.put("errorHandler", true);
    config.put("errorContinue", true);
    config.put("errorPropagate", false);
    return this;
  }

  /**
   * Makes the policy to define an on-error-propagate handler.
   */
  public Config errorPropagate() {
    config.put("errorHandler", true);
    config.put("errorContinue", false);
    config.put("errorPropagate", true);
    return this;
  }

  /**
   * Makes the policy to not define any error handler.
   */
  public Config noErrorHandler() {
    config.put("errorHandler", false);
    config.put("errorContinue", false);
    config.put("errorPropagate", false);
    return this;
  }

  /**
   * Makes the policy to raise an error before executing the operation.
   */
  public Config errorBefore() {
    config.put("raiseErrorBefore", true);
    return this;
  }

  /**
   * Makes the policy to raise an error after executing the operation.
   */
  public Config errorAfter() {
    config.put("raiseErrorAfter", true);
    return this;
  }

  /**
   * Indicates that the policy Error Handler should be executed. Used to assert that a variable set in the policy operation
   * error-handler is available afterwards in the source part of the same policy.
   */
  public Config shouldExecuteErrorHandler() {
    config.put("shouldExecuteEh", true);
    return this;
  }

  public Map<String, Object> get() {
    return config;
  }

}
