/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error;

import org.mule.tck.junit4.AbstractMuleTestCase;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import java.util.Map;

public abstract class PolicyErrorHandlingScenarios extends AbstractMuleTestCase {

  protected SerialExecutor serialExecutor = new SerialExecutor(Runtime.getRuntime().availableProcessors() + 1);

  public PolicyDefinition policyDefinition(int order, PolicyTemplateKey templateKey, ApiKey apiKey,
                                           Map<String, Object> configData) {
    return new PolicyDefinition(String.valueOf(order), templateKey, apiKey, null, order, new PolicyConfiguration(configData));
  }

  public enum StatusCodeMode {
    DEFAULT_STATUS_CODE, OVERRIDE_STATUS_CODE
  }

  public enum HeadersMode {
    INCLUDE_HEADERS, DONT_INCLUDE_HEADERS
  }
}
