/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error;

/**
 * This class executes the provided runnable a specified amount of times in a serial way.
 */
public class SerialExecutor {

  private int count;

  /**
   * @param count The amount of times for the runnables to be executed.
   * @throws IllegalArgumentException in case that count is less than 1.
   */
  public SerialExecutor(int count) {
    if (count <= 0) {
      throw new IllegalArgumentException("Serial count must be at least 1.");
    }
    this.count = count;
  }

  /**
   * This method will run the provided runnable the amount of times specified in this object constructor
   *
   * @param runnable The runnable that will be serially executed.
   */
  public void execute(Runnable runnable) {
    for (int i = 0; i < count; i++) {
      runnable.run();
    }
  }
}
